package be.WAAR.PresentationLayer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * GenericEnumerationType is the presentation type for enumerated values
 * 
 * @author Erwin
 */
public abstract class NumberedEnumerationType extends GenericEnumerationType {

	/**
	 * 
	 */
	private boolean caseSensitive = false;

	/**
	 * The textual values of all the enumerated possibilities
	 */
	private String labels[];

	/**
	 * Creates the Enumeration type instance
	 * 
	 * @param labels
	 *            The valid values for the enumeration
	 */
	public NumberedEnumerationType (String[] labels) {
		this.labels = labels;
		HashSet<String> s = new HashSet<String>();
		for (int i = 0; i < labels.length && !caseSensitive; i++) {
			String ucLabel = labels[i].toUpperCase();
			if (s.contains(ucLabel)) {
				caseSensitive = true;
			} else {
				s.add(ucLabel);
			}
		}
	}

	/**
	 * Gets labels
	 * 
	 * @return labels.
	 */
	final String[] getLabels ( ) {
		return labels;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.waar.AttributeType#validate(java.lang.String)
	 */
	public final WaarValue encode (String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
		int c = 0;
		while (c < labels.length) {
			if ((labels[c].equalsIgnoreCase(val) && !caseSensitive) || (labels[c].equals(val) && caseSensitive)) {
				return new NumberedEnumerationValue(c + 1, this);
			} else {
				c++;
			}
		}

		try {
			int index = Integer.parseInt(val);
			if (index <= labels.length) {
				return new NumberedEnumerationValue(index, this);
			}
		} catch (NumberFormatException e) {

		}

		throw new InvalidAttributeValueException(val, this.getClass().getSimpleName(), new HashSet<String>(Arrays.asList(labels)).toString(), locale);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getDefaultPresentationRenderingStyle()
	 */
	@Override
	public final Renderer getDefaultPresentationRenderingStyle ( ) {
		return RadioButtonRenderer.getInstance();
	}

	public final String getEmptyNakedStringRepresentation (PresentationField presentationField, Locale locale) {
		return ""; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.waar.AttributeType#validate(java.lang.String)
	 */
	public final String getNakedStringRepresentation (WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		if (waarValue instanceof NumberedEnumerationValue) {
			int offsetValue = ((NumberedEnumerationValue) waarValue).getIntegerValue() - 1;
			//			String htmlFieldValue = ""; //$NON-NLS-1$
			return (offsetValue >= 0 && offsetValue < labels.length ? labels[offsetValue] : ""); //$NON-NLS-1$
			// int c = 0;
			// while (c < labels.length) {
			// if (c > 0) {
			//					htmlFieldValue += "<BR>"; //$NON-NLS-1$
			// }
			//				htmlFieldValue += ("<INPUT TYPE=\"RADIO\" NAME=\"" + presentationField.getName() + "\" VALUE=\"" + labels[c] + "\" " + (c == offsetValue ? "CHECKED" : "") + " >" + labels[c] + "</INPUT>"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			// c++;
			// }
			// return htmlFieldValue;
		} else {
			if (waarValue == null) {
				return ""; //$NON-NLS-1$
				//				String htmlFieldValue = ""; //$NON-NLS-1$
				// int c = 0;
				// while (c < labels.length) {
				// if (c > 0) {
				//						htmlFieldValue += "<BR>"; //$NON-NLS-1$
				// }
				//					htmlFieldValue += ("<INPUT TYPE=\"RADIO\" NAME=\"" + presentationField.getName() + "\" VALUE=\"" + labels[c] + "\" " + " >" + labels[c] + "</INPUT>"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
				// c++;
				// }
				// return htmlFieldValue;
			} else {
				throw new IllegalArgumentException(waarValue.getClass().getName());
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getPresentationRenderingStyle(java.lang.String)
	 */
	@Override
	public final Renderer getPresentationRenderingStyle (String renderingStyleName) {
		if (renderingStyleName.equalsIgnoreCase("PASSWORD")) { //$NON-NLS-1$
			return PassWordRenderer.getInstance();
		}
		if (renderingStyleName.equalsIgnoreCase("TEXTBOX")) { //$NON-NLS-1$
			return TextBoxRenderer.getInstance();
		}
		if (renderingStyleName.equalsIgnoreCase("COMBOBOX")) { //$NON-NLS-1$
			return ComboBoxRenderer.getInstance();
		}
		return RadioButtonRenderer.getInstance();
	}

	@Override
	public final WaarValue getWaarValue (int v, Locale locale) throws InvalidAttributeValueException {
		if (v < 1 || v > labels.length) {
			throw new InvalidAttributeValueException(Integer.toString(v), this.getClass().getName(), new HashSet<String>(Arrays.asList(labels)).toString(), locale);
		}
		return new NumberedEnumerationValue(v, this);
	}

	/**
	 * @param integer
	 * @return The text corresponding to the numeric value
	 */
	public final String toString (int integer) {
		return labels[integer - 1];
	}

	/**
	 * @param i
	 * @param locale
	 * @return
	 * @throws InvalidAttributeValueException
	 */
	public final NumberedEnumerationValue value (int i, Locale locale) throws InvalidAttributeValueException {
		if (i < 1 || i > labels.length) {
			throw new InvalidAttributeValueException(Integer.toString(i), this.getClass().getSimpleName(), new HashSet<String>(Arrays.asList(labels)).toString(), locale);
		}
		return new NumberedEnumerationValue(i, this);
	}

	@Override
	public final WaarValue getWaarValue (long v, Locale locale) throws InvalidAttributeValueException {
		if (v < 1 || v > labels.length) {
			throw new InvalidAttributeValueException(Long.toString(v), this.getClass().getName(), new HashSet<String>(Arrays.asList(labels)).toString(), locale);
		}
		return new NumberedEnumerationValue((int) v, this);
	}

	@Override
	public final WaarValue getWaarValue (boolean b, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#checkValidWaarValue(be.WAAR.PresentationLayer.WaarValue, be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public final WaarValue checkValidWaarValue (WaarValue value, UserData userData) throws InvalidAttributeValueException {
		if (!(value instanceof NumberedEnumerationValue)) {
			Locale locale = userData.getLocale();
			throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[] { getClass().getName(), value.getClass().getName() }), locale); //$NON-NLS-1$
		}
		int i = ((NumberedEnumerationValue) value).getIntegerValue();
		if (i < 1 || i > labels.length) {
			Locale locale = userData.getLocale();
			throw new InvalidAttributeValueException(Integer.toString(i), this.getClass().getSimpleName(), new HashSet<String>(Arrays.asList(labels)).toString(), locale);
		}
		return value;
	}
}
