/*
 * Created on 5-feb-2008
 */
package be.WAAR.PresentationLayer;

/**
 * GenericEnumValue is the Class holding presentation values of the enumeration presentation type
 * 
 * @author Erwin Smout
 */
public class NumberedEnumerationValue implements WaarValue {

	/**
	 * The type corresponding to the value
	 */
	private NumberedEnumerationType enumerationType;

	/**
	 * The integer number of this value
	 */
	private int integerValue;

	/**
	 * Creates the value
	 * 
	 * @param i
	 *            The integer number of this value
	 * @param type
	 *            The type corresponding to the value
	 */
	public NumberedEnumerationValue (int i, NumberedEnumerationType type) {
		this.integerValue = i;
		this.enumerationType = type;
	}

	/**
	 * Gets The integer number of this value
	 * 
	 * @return The integer number of this value
	 */
	public int getIntegerValue ( ) {
		return integerValue;
	}

	/**
	 * Gets The textual representation of this value
	 * 
	 * @return The textual representation of this value
	 */
	public String getStringValue ( ) {
		return enumerationType.toString(integerValue);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.WaarValue#toWAARString(be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public String toWAARString (UserData userData) {
		return enumerationType.toString(integerValue);
	}

}
