/**
 * 
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;

/**
 * @author Erwin
 * 
 */
final class PassWordRenderer extends Renderer {

	/**
	 * 
	 */
	private static Renderer instance = new PassWordRenderer();

	/**
	 * @return
	 */
	static Renderer getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private static final String asterisks = "********"; //$NON-NLS-1$

	/**
	 * Creates the GenericDateRenderer
	 * 
	 */
	private PassWordRenderer ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#emptyHTML(be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getEmptyHTML (PresentationField presentationField, Locale locale) {
		if (presentationField.isInputEnabled()) {
			return "<INPUT type=\"password\"" + getHTMLControlNameSpec(presentationField) + getHTMLSizeAttributeSpec(presentationField) + getHTMLTabIndexSpec(presentationField) + " value=\"\">"; //$NON-NLS-1$//$NON-NLS-2$
		} else {
			return ""; //$NON-NLS-1$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#renderHTML(be.erwinsmout.WAAR.WaarValue, be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction, be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getHTML (WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		String stringValue = processEntityRefs(presentationFieldValue.toWAARString(userFunction.getUserData()));

		if (presentationField.isInputEnabled()) {
			return "<INPUT type=\"password\"" + getHTMLControlNameSpec(presentationField) + getHTMLSizeAttributeSpec(presentationField) + getHTMLTabIndexSpec(presentationField) + " value=\"" + stringValue + "\">"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
		} else {
			return asterisks.substring(0, Math.min(asterisks.length(), stringValue.length()));
		}
	}
}
