package be.WAAR.PresentationLayer;

import java.io.*;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Erwin
 */
public class Presentation {

	/**
	 * 
	 */
	private static final String __LINK__ = "__LINK__"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String LABELSSUFFIX = ".labels"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PRESENTATIONSUFFIX = ".pres"; //$NON-NLS-1$

	/**
	 * 
	 */
	private Properties labelsForLanguageUnspecified = new Properties();

	/**
	 * The info message on the presentation
	 */
	private String message = ""; //$NON-NLS-1$

	/**
	 * The name of the presentation
	 */
	private String name;

	/**
	 * 
	 */
	private HashMap<String, Properties> nlPresentationLabels = new HashMap<String, Properties>();

	/**
	 * The ordered list of presentation-specific action buttons. The list contains the value for the value attribute of the html <INPUT> tag named "action".
	 */
	private LinkedList<String> presentationActions = new LinkedList<String>();

	/**
	 * The list of fields and their respective presentation attributes
	 */
	private HashMap<String, PresentationField> presentationFields = new HashMap<String, PresentationField>();

	/**
	 * The map of presentation attribute names and values
	 */
	private HashMap<String, WaarValue> presentationValues = new HashMap<String, WaarValue>();

	/**
	 * Creates the GenericPresentation object from its config file
	 * 
	 * @param presentationFunctionClass
	 *            The Class object of the presentation function. This is to allow access to related resources via that Class' ClassLoader (which is not necessarily the same as the architecutre's)
	 * @param name
	 *            The name of the presentation
	 * @param locale
	 * @throws WaarException
	 */
	public Presentation (Class<? extends OnLinePresentationFunction> presentationFunctionClass, String name, Locale locale) throws WaarException {
		this.name = name;
		String w;

		BufferedReader in;
		try {
			in = Architecture.getResourceReader(name + PRESENTATIONSUFFIX, presentationFunctionClass);
		} catch (ResourceNotFoundException e2) {
			throw new PresentationMissingException(name, locale);
		}

		PresentationField currentListField = null;
		LinkedList<PresentationField> listFieldStack = new LinkedList<PresentationField>();
		try {
			while ((w = in.readLine()) != null) {
				w = w.trim();
				if (w.length() > 0 && !(w.startsWith("# "))) { //$NON-NLS-1$
					PresentationField presentationField;
					if (currentListField == null) {
						if (w.length() > 6 && w.substring(0, 7).equalsIgnoreCase("ACTION ")) { //$NON-NLS-1$
							presentationActions.addLast(w.substring(7).trim());
						} else {
							presentationField = new PresentationField(w, presentationFunctionClass, locale);
							presentationFields.put(presentationField.getName(), presentationField);
							if (presentationField.getType() instanceof List || presentationField.getType() instanceof DynamicColumnList) {
								// if (currentListField != null) {
								listFieldStack.addLast(currentListField);
								// }
								currentListField = presentationField;
								if (currentListField.getType() instanceof List) { // And thus not of dynamiccolumnlist
									currentListField.setTableRowHtml(name, presentationFunctionClass);
								}
							}
						}
					} else {
						// We're adding in a current list field
						if (w.equals("(")) { //$NON-NLS-1$
							// nothing to do, that's part of the old syntax. We have already set up the new current list field
						} else {
							if (w.equals(")")) { //$NON-NLS-1$
								if (listFieldStack.size() > 0) {
									currentListField = listFieldStack.removeLast();
								} else {
									currentListField = null;
								}
							} else {
								presentationField = new PresentationField(w, presentationFunctionClass, locale);
								currentListField.addColumn(presentationField);
								if (presentationField.getType() instanceof List || presentationField.getType() instanceof DynamicColumnList) {
									// if (currentListField != null) {
									listFieldStack.addLast(currentListField);
									// }
									currentListField = presentationField;
									if (currentListField.getType() instanceof List) { // And thus not of dynamiccolumnlist
										currentListField.setTableRowHtml(name, presentationFunctionClass);
									}
								}
							}
						}
					}
				}
			}
		} catch (IOException e) {
			presentationFields.clear();
			throw new PresentationDefinitionsIOException(e, locale);
		} finally {
			try {
				in.close();
			} catch (IOException e1) {

			}
		}

		try {
			InputStream labelsForLanguageUnspecifiedInputStream = Architecture.getResourceInputStream(name + LABELSSUFFIX, presentationFunctionClass);
			try {
				labelsForLanguageUnspecified.load(labelsForLanguageUnspecifiedInputStream);
			} catch (IOException e) {
				labelsForLanguageUnspecified.clear();
			} finally {
				try {
					labelsForLanguageUnspecifiedInputStream.close();
				} catch (IOException e) {

				}
			}
		} catch (ResourceNotFoundException e2) {
			labelsForLanguageUnspecified.clear();
		}

		// Load all the NL-labels
		Set<String> languages = Architecture.supportedLanguages().keySet();
		for (String language : languages) {
			Properties labelsForLanguageSpecified = new Properties(labelsForLanguageUnspecified);
			try {
				InputStream labelsForLanguageSpecifiedInputStream = Architecture.getResourceInputStream(name + LABELSSUFFIX + '.' + language, presentationFunctionClass);
				try {
					labelsForLanguageSpecified.load(labelsForLanguageSpecifiedInputStream);
				} catch (IOException e) {
					labelsForLanguageSpecified.clear();
				} finally {
					try {
						labelsForLanguageSpecifiedInputStream.close();
					} catch (IOException e) {

					}
				}
			} catch (ResourceNotFoundException e2) {
				labelsForLanguageSpecified.clear();
			}

			nlPresentationLabels.put(language, labelsForLanguageSpecified);
		}
	}

	/**
	 * @param locale
	 * 
	 */
	private void eraseInputFields (Locale locale) {
		Locale useLocale = locale == null ? Architecture.getDefaultLocale() : locale;
		for (Entry<String, PresentationField> me : presentationFields.entrySet()) {
			String attributeName = me.getKey();
			PresentationField presentationField = me.getValue();
			if (presentationField.isInputEnabled()) {
				// Fix the HTML feature that unchecked checkboxes are never transmitted.
				if (presentationField.getType().isTheBoolean()) {
					presentationValues.put(attributeName, presentationField.getType().getWaarValue(false, useLocale));
				} else {
					presentationValues.remove(attributeName);
				}
			}
		}
	}

	/**
	 * @param req
	 * @param userData
	 * @throws InvalidAttributeValueException
	 */
	private void setPresentationInputValuesFromLinkParameters (HttpServletRequest req, UserData userData) throws InvalidAttributeValueException {
		Enumeration<?> parameterNames = req.getParameterNames();

		while (parameterNames.hasMoreElements()) {
			String presentationFieldName = (String) parameterNames.nextElement();
			if (presentationFieldName.startsWith(__LINK__)) {
				String sanitizedPresentationFieldName = HTMLEntityRefs.V4_0.fromEntityRefsToUnicodeString(presentationFieldName).substring(__LINK__.length());
				if (presentationFields.containsKey(sanitizedPresentationFieldName)) {
					PresentationField presentationField = presentationFields.get(sanitizedPresentationFieldName);
					// if (presentationField.isInputEnabled()) {
					String parameterValue = req.getParameter(presentationFieldName);
					// Hack for the peculiar way in which HTML deals with checkboxes and boolean parameters
					Locale locale = userData == null ? Architecture.getDefaultLocale() : userData.getLocale();
					if (locale == null) {
						locale = Architecture.getDefaultLocale(); // is the case when starting the logon servlet
					}
					if (presentationField.getType() instanceof Logical) {
						if (parameterValue != null && parameterValue.length() > 0) {
							// parameterValue can still be "FALSE"
							// But beware : that introduces locale-dependency (what about "faux", "onwaar", ... ? And what about system-values, hardcoded in English when user chooses some other locale ?)
							//								this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(I18N.getString(locale, "Logical.True"), userData, locale)); //$NON-NLS-1$
							this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(parameterValue, userData, locale));
						} else {
							this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(I18N.getString(locale, "Logical.False"), userData, locale)); //$NON-NLS-1$
						}
					} else {
						if (parameterValue != null && parameterValue.length() > 0) {
							this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(HTMLEntityRefs.V4_0.fromEntityRefsToUnicodeString(parameterValue), userData, locale));
						}
					}
					// }
				}
			}
		}
	}

	/**
	 * @param req
	 * @param userData
	 * @throws InvalidAttributeValueException
	 */
	private void setPresentationInputValuesFromReqParameters (HttpServletRequest req, UserData userData) throws InvalidAttributeValueException {
		// int contentLength = req.getContentLength();
		// try {
		// char[] arr = new char[contentLength];
		// req.getReader().read(arr, 0, contentLength);
		// System.out.println(new String(arr));
		// } catch (IOException e) {
		// e.printStackTrace(System.err);
		// }
		// System.out.println("METHOD"+req.getMethod());
		// if (req.getMethod().equalsIgnoreCase("POST")) {
		// System.out.println("URI"+req.getRequestURI());
		// // sysout(HttpUtils.getRequestURL(req));
		// }
		//		System.out.println("ENCODING " + req.getCharacterEncoding()); //$NON-NLS-1$
		// Enumeration b = req.getHeaderNames();
		// while (b.hasMoreElements()) {
		// Object nextElement = b.nextElement();
		//			System.out.println("HEADER" + nextElement + "/" + req.getHeader((String) nextElement)); //$NON-NLS-1$
		// }
		// Enumeration p = req.getParameterNames();
		// while (p.hasMoreElements()) {
		// Object nextElement = p.nextElement();
		//			System.out.println("PARM" + nextElement + "/" + req.getParameter((String) nextElement)); //$NON-NLS-1$
		// }

		Enumeration<?> parameterNames = req.getParameterNames();

		while (parameterNames.hasMoreElements()) {
			String presentationFieldName = (String) parameterNames.nextElement();
			String sanitizedPresentationFieldName = HTMLEntityRefs.V4_0.fromEntityRefsToUnicodeString(presentationFieldName);
			if (presentationFields.containsKey(sanitizedPresentationFieldName)) {
				PresentationField presentationField = presentationFields.get(sanitizedPresentationFieldName);
				if (presentationField.isInputEnabled()) {

					String parameterValue = req.getParameter(presentationFieldName);
					Locale locale = userData == null ? Architecture.getDefaultLocale() : userData.getLocale();
					if (locale == null) {
						locale = Architecture.getDefaultLocale(); // is the case when starting the logon servlet
					}
					// Hack for the peculiar way in which HTML deals with checkboxes and boolean parameters
					if (presentationField.getType() instanceof Logical) {
						if (parameterValue != null && parameterValue.length() > 0) {
							// parameterValue can still be "FALSE"
							// But beware : that introduces locale-dependency (what about "faux", "onwaar", ... ? And what about system-values, hardcoded in English when user chooses some other locale ?)
							//							this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(I18N.getString(locale, "Logical.True"), userData, locale)); //$NON-NLS-1$
							this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(parameterValue, userData, locale));
						} else {
							this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(I18N.getString(locale, "Logical.False"), userData, locale)); //$NON-NLS-1$
						}
					} else {
						if (parameterValue != null && parameterValue.length() > 0) {
							this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(HTMLEntityRefs.V4_0.fromEntityRefsToUnicodeString(parameterValue), userData, locale));
						}
					}
				}
			}
		}
	}

	/**
	 * Gets the labels defined for this presentation, for the specified locale
	 * 
	 * @param locale
	 * @return
	 */
	Properties getLabels (Locale locale) {
		Properties labels = nlPresentationLabels.get(locale.getLanguage().toUpperCase());
		if (labels == null) {
			return labelsForLanguageUnspecified;
		}
		return labels;
	}

	/**
	 * Gets The ordered list of presentation-specific action buttons. The list contains the value for the value attribute of the html <INPUT> tag named "action".
	 * 
	 * @return The ordered list of presentation-specific action buttons. The list contains the value for the value attribute of the html <INPUT> tag named "action".
	 */
	LinkedList<String> getPresentationActions ( ) {
		return presentationActions;
	}

	/**
	 * Sets the presentation message field
	 * 
	 * @param message
	 *            the message to be displayed
	 */
	void setMessage (String message) {
		this.message = message;
	}

	/**
	 * @param req
	 * @param userData
	 * @throws MandatoryFieldMissingException
	 * @throws InvalidAttributeValueException
	 */
	void setPresentationValuesIgnoringDefaults (HttpServletRequest req, UserData userData) throws MandatoryFieldMissingException, InvalidAttributeValueException {
		// this.presentationValues = getPresentationWaarValueMap(req, userData, false);
		eraseInputFields(userData == null ? Architecture.getDefaultLocale() : userData.getLocale());
		setPresentationInputValuesFromReqParameters(req, userData);

		Iterator<PresentationField> i_presentationFields = presentationFields.values().iterator();
		while (i_presentationFields.hasNext()) {
			PresentationField presentationField = i_presentationFields.next();
			String attributeName = presentationField.getName();
			if (presentationValues.get(attributeName) == null) {
				if (presentationField.isInputEnabled() && presentationField.isMandatory()) {
					throw new MandatoryFieldMissingException(attributeName, (userData == null ? Architecture.getDefaultLocale() : userData.getLocale()));
				}
			}
		}
	}

	/**
	 * @param req
	 * @param userData
	 * @throws InvalidAttributeValueException
	 */
	void setPresentationValuesIncludingDefaults (HttpServletRequest req, UserData userData) throws InvalidAttributeValueException {
		eraseInputFields(userData == null ? Architecture.getDefaultLocale() : userData.getLocale());
		setPresentationInputValuesFromReqParameters(req, userData);
		setPresentationInputValuesFromLinkParameters(req, userData);

		// get all the default values off the presentationfielddefinitions
		for (PresentationField presentationField : getPresentationFields().values()) {
			if (presentationField.getDefaultValue() != null) {
				if (!presentationValues.containsKey(presentationField.getName())) {
					presentationValues.put(presentationField.getName(), presentationField.getDefaultValue());
				}
			}
		}
	}

	/**
	 * Gets the Presentation message field
	 * 
	 * @return the Presentation message field
	 */
	public final String getMessage ( ) {
		return message;
	}

	/**
	 * Gets the name of the current presentation
	 * 
	 * @return The name of the current presentation
	 */
	public final String getName ( ) {
		return name;
	}

	/**
	 * @param presentationFieldName
	 * @param locale
	 * @return the PresentationField object
	 * @throws WaarException
	 */
	public final PresentationField getPresentationField (String presentationFieldName, Locale locale) throws WaarException {
		if (presentationFields.containsKey(presentationFieldName)) {
			return presentationFields.get(presentationFieldName);
		} else {
			throw new PresentationFieldMissingException(presentationFieldName, name, locale);
		}
	}

	/**
	 * Gets the list of fields and their respective presentation attributes
	 * 
	 * @return The list of fields and their respective presentation attributes
	 */
	public final HashMap<String, PresentationField> getPresentationFields ( ) {
		return presentationFields;
	}

	/**
	 * Gets the map of presentation attribute names and values
	 * 
	 * @return The map of presentation attribute names and values
	 */
	public final HashMap<String, WaarValue> getPresentationValues ( ) {
		return presentationValues;
	}

	/**
	 * @param presentationFieldName
	 * @param mode
	 * @param locale
	 * @throws WaarException
	 */
	public final void setPresentationFieldInOutMode (String presentationFieldName, InOutMode mode, Locale locale) throws WaarException {
		getPresentationField(presentationFieldName, locale).setInOutMode(mode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString ( ) {
		return name + presentationFields;
	}
}
