/*
 * Created on 24-mrt-05
 */
package be.WAAR.PresentationLayer;

import java.util.*;

/**
 * The PresentationArchitectureFieldMap is the map of Architecture field names and their corresponding ValueGetters
 * 
 * @author Erwin
 */
final class PresentationArchitectureFieldMap extends HashMap<String, ArchitectureValueGetter> {

	/**
	 * The instance of the map
	 */
	private static PresentationArchitectureFieldMap instance = new PresentationArchitectureFieldMap();

	/**
	 * 
	 */
	private static final long serialVersionUID = -8313999835008551056L;

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static PresentationArchitectureFieldMap getInstance ( ) {
		return instance;
	}

	/**
	 * Creates the Architecture field map
	 */
	private PresentationArchitectureFieldMap ( ) {
		put("CharSet", ArchitectureValueGetterForCharSet.getInstance()); //$NON-NLS-1$
		put("Date", ArchitectureValueGetterForDate.getInstance()); //$NON-NLS-1$
		put("Time", ArchitectureValueGetterForTime.getInstance()); //$NON-NLS-1$
		put("Message", ArchitectureValueGetterForMessage.getInstance()); //$NON-NLS-1$
		put("ApplicationName", ArchitectureValueGetterForApplicationName.getInstance()); //$NON-NLS-1$
		put("ServerInfo", ArchitectureValueGetterForServerInfo.getInstance()); //$NON-NLS-1$
		put("PresentationName", ArchitectureValueGetterForPresentationName.getInstance()); //$NON-NLS-1$
		put("PresentationFunction", ArchitectureValueGetterForPresentationFunction.getInstance()); //$NON-NLS-1$
		put("Userid", ArchitectureValueGetterForUserid.getInstance()); //$NON-NLS-1$
		put("USERSESSIONID", ArchitectureValueGetterForUSERSESSIONID.getInstance()); //$NON-NLS-1$
		put("USERSESSIONTOKEN", ArchitectureValueGetterForUSERSESSIONTOKEN.getInstance()); //$NON-NLS-1$
	}
}
