package be.WAAR.PresentationLayer;

import java.util.Locale;

/**
 * A PresentationFunction is the top level function in the Architecture's three-layer "presentation/business/data" software model
 * 
 * @author Erwin
 */
public class PresentationFunction {

	/**
	 * The application name
	 */
	private String applicationName;

	/**
	 * Data about the user that is performing the function
	 */
	private UserData userData;

	/**
	 * Gets the applicable user language. If there is a user session, then it is retrieved from the UserData in the session. Otherwise it is the architecture's installation default. This latter case applies during the OnLinePresentation logon function.
	 * 
	 * @return The applicable language
	 * @deprecated - replace with getUserLocale()
	 */
	final GenericStringValue getApplicableUserLanguage ( ) {
		GenericStringValue language = userData == null ? Architecture.getDefaultLanguage() : userData.getUserLanguage();
		return language;
	}

	/**
	 * Gets The function's application name
	 * 
	 * @return The function's application name
	 */
	final String getApplicationName ( ) {
		return applicationName;
	}

	/**
	 * Sets the application name
	 * 
	 * @param applicationName
	 *            the application name
	 */
	final void setApplicationName (String applicationName) {
		this.applicationName = applicationName;
	}

	/**
	 * Sets data about the user that is performing the function
	 * 
	 * @param userData
	 *            data about the user that is performing the function
	 */
	final void setUserData (UserData userData) {
		this.userData = userData;
	}

	/**
	 * Gets data about the user that is performing the function
	 * 
	 * @return Data about the user that is performing the function
	 */
	public final UserData getUserData ( ) {
		return userData;
	}

	/**
	 * Gets the applicable user locale. If there is a user session, then it is retrieved from the UserData in the session. Otherwise it is the architecture's installation default. This latter case applies during the OnLinePresentation logon function.
	 * 
	 * @return The applicable locale
	 */
	public final Locale getUserLocale ( ) {
		return userData == null ? Architecture.getDefaultLocale() : userData.getLocale();
	}
}
