package be.WAAR.PresentationLayer;

import java.util.Locale;

/**
 * An AttributeType defines the set of valid values that a field of that type may have.
 * 
 * @author Erwin
 */
public abstract class PresentationType {

	/**
	 * @return
	 */
	final boolean isTheBoolean ( ) {
		return this.getClass() == Logical.class;
	}

	/**
	 * Validates whether a String is a representation of a valid value for the type.
	 * 
	 * @param val
	 *            The value to be validated in String representation.
	 * @param userData
	 *            The userData object that might be needed to obtain the user's preferences (e.g. DateFormat)
	 * @param locale
	 *            The locale in which to set any exception message, if needed
	 * @return The value in internal encoded format
	 * @throws InvalidAttributeValueException
	 */
	public abstract WaarValue encode (String val, UserData userData, Locale locale) throws InvalidAttributeValueException;

	/**
	 * Gets The default presentation renderer for this presentation data type
	 * 
	 * @return The default presentation renderer for this presentation data type
	 */
	public abstract Renderer getDefaultPresentationRenderingStyle ( );

	/**
	 * @param presentationField
	 *            The presentation field
	 * @param locale
	 *            The locale to take into account
	 * @return The html to be used if and when a presentation field has been given no value
	 */
	public String getEmptyNakedStringRepresentation (PresentationField presentationField, Locale locale) {
		presentationField.getClass();
		locale.getClass();
		return ""; //$NON-NLS-1$
	}

	/**
	 * Decodes a WaarValue to its textual representation
	 * 
	 * @param waarValue
	 *            The value to convert to textual representation
	 * @param userFunction
	 *            The user function for which the decoding is to be done
	 * @param presentationField
	 *            The presentation field for which this decode operation is requested
	 * @param locale
	 *            The locale in which to set possible exception messages, or to take into account when decoding locale-sensitive content
	 * @return the value in textual format
	 */
	public abstract String getNakedStringRepresentation (WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale);

	/**
	 * Gets the Renderer implementing the rendering style indicated by the given rendering style name
	 * 
	 * @param renderingStyleName
	 *            the rendering style
	 * @return the Renderer implementing the rendering style indicated by the given rendering style name
	 */
	public abstract Renderer getPresentationRenderingStyle (String renderingStyleName);

	/**
	 * @param b
	 * @param locale
	 * @return
	 */
	public abstract WaarValue getWaarValue (boolean b, Locale locale);

	/**
	 * Gets the most appropriate WaarValue object corresponding to the given java native integer value. This may, e.g., be a GenericInteger, or a NumberedEnumerationValue, or a GenericLong, or a GenericString, ...
	 * 
	 * @param v
	 *            The value to "convert" into a Presentation Layer value
	 * @param locale
	 *            The locale to use when generating excertion messages
	 * @return the most appropriate WaarValue object corresponding to the given java native integer value. This may, e.g., be a GenericInteger, or a NumberedEnumerationValue, or a GenericLong, or a GenericString, ...
	 * @throws InvalidAttributeValueException 
	 */
	public abstract WaarValue getWaarValue (int v, Locale locale) throws InvalidAttributeValueException;

	/**
	 * Gets the most appropriate WaarValue object corresponding to the given java native long value. This may, e.g., be a GenericInteger, or a NumberedEnumerationValue, or a GenericLong, or a GenericString, ...
	 * 
	 * @param v
	 *            The value to "convert" into a Presentation Layer value
	 * @param locale
	 *            The locale to use when generating excertion messages
	 * @return the most appropriate WaarValue object corresponding to the given java native long value. This may, e.g., be a GenericInteger, or a NumberedEnumerationValue, or a GenericLong, or a GenericString, ...
	 * @throws InvalidAttributeValueException
	 */
	public abstract WaarValue getWaarValue (long v, Locale locale) throws InvalidAttributeValueException;

	/**
	 * @param value
	 * @param userData 
	 * @return 
	 * @throws InvalidAttributeValueException 
	 */
	public abstract WaarValue checkValidWaarValue (WaarValue value, UserData userData) throws InvalidAttributeValueException;
}
