/**
 * 
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;


/**
 * @author Erwin
 * 
 */
final class RadioButtonRenderer extends Renderer {

	/**
	 * 
	 */
	private static Renderer instance = new RadioButtonRenderer();

	/**
	 * @return
	 */
	static Renderer getInstance ( ) {
		return instance;
	}

	/**
	 * Creates the RadioButtonRenderer
	 * 
	 */
	private RadioButtonRenderer ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#emptyHTML(be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getEmptyHTML (PresentationField presentationField, Locale locale) {
		return getHTML(null, null, presentationField, locale);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#renderHTML(be.erwinsmout.WAAR.WaarValue, be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction, be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getHTML (WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		String[] labels = ((NumberedEnumerationType) presentationField.getType()).getLabels();
		if (presentationFieldValue instanceof NumberedEnumerationValue) {
			NumberedEnumerationValue numberedEnumerationValue = (NumberedEnumerationValue) presentationFieldValue;
			int offsetValue = numberedEnumerationValue.getIntegerValue() - 1;
			StringBuilder htmlFieldValue = new StringBuilder(80 * labels.length);
			int c = 0;
			while (c < labels.length) {
				if (c > 0) {
					htmlFieldValue.append("<BR>"); //$NON-NLS-1$
				}
				String cookedLabel = processEntityRefs(labels[c]);
				htmlFieldValue.append("<INPUT TYPE=\"RADIO\"").append(getHTMLControlNameSpec(presentationField)).append(getHTMLTabIndexSpec(presentationField)).append(" VALUE=\"").append(cookedLabel).append("\" ").append((c == offsetValue ? "CHECKED" : "")).append(" >").append(cookedLabel).append("</INPUT>"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
				c++;
			}
			return htmlFieldValue.toString();
		} else {
			if (presentationFieldValue == null) {
				StringBuilder htmlFieldValue = new StringBuilder(80 * labels.length);
				int c = 0;
				while (c < labels.length) {
					if (c > 0) {
						htmlFieldValue.append("<BR>"); //$NON-NLS-1$
					}
					String cookedLabel = processEntityRefs(labels[c]);
					htmlFieldValue.append("<INPUT TYPE=\"RADIO\"").append(getHTMLControlNameSpec(presentationField)).append(getHTMLTabIndexSpec(presentationField)).append(" VALUE=\"").append(cookedLabel).append("\" ").append(" >").append(cookedLabel).append("</INPUT>"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
					c++;
				}
				return htmlFieldValue.toString();
			} else {
				throw new IllegalArgumentException(presentationFieldValue.getClass().getName());
			}
		}
	}
}
