/**
 * 
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;


/**
 * @author Erwin
 * 
 */
public abstract class Renderer {

	/**
	 * @param presentationField
	 * @param locale 
	 * @return
	 */
	abstract String getEmptyHTML (PresentationField presentationField, Locale locale);

	/**
	 * @param presentationFieldValue
	 * @param userFunction
	 * @param presentationField
	 * @param locale 
	 * @return
	 */
	abstract String getHTML (WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale);

	/**
	 * @param presentationField
	 * @return
	 */
	final String getHTMLControlNameSpec (PresentationField presentationField) {
		return " name=\"" + presentationField.getName() + "\""; //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * @param presentationField
	 * @return
	 */
	final String getHTMLSizeAttributeSpec (PresentationField presentationField) {
		String presentationSizeSpec = presentationField.getPresentationSizeSpec();
		return presentationSizeSpec.length() > 0 ? " size=\"" + presentationSizeSpec + "\"" : ""; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}

	/**
	 * @param presentationField
	 * @return
	 */
	final String getHTMLTabIndexSpec (PresentationField presentationField) {
		int presentationFieldTabIndex = presentationField.getTabIndex();
		return presentationFieldTabIndex == -1 ? "" : " tabindex=\"" + presentationFieldTabIndex + "\""; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
	}

	/**
	 * @param presentationFieldValue
	 * @return
	 */
	final String processEntityRefs (String presentationFieldValue) {
		StringBuilder stringBuilder = new StringBuilder(presentationFieldValue);
		int p;
		while ((p = stringBuilder.indexOf("\"")) >= 0) { //$NON-NLS-1$
			stringBuilder.deleteCharAt(p).insert(p, "&quot;"); //$NON-NLS-1$
		}
		// while ((p = sb.indexOf("'")) >= 0) { //$NON-NLS-1$
		// sb.deleteCharAt(p).insert(p,"&apost;"); //$NON-NLS-1$
		// }
		while ((p = stringBuilder.indexOf("<")) >= 0) { //$NON-NLS-1$
			stringBuilder.deleteCharAt(p).insert(p, "&lt;"); //$NON-NLS-1$
		}
		while ((p = stringBuilder.indexOf(">")) >= 0) { //$NON-NLS-1$
			stringBuilder.deleteCharAt(p).insert(p, "&gt;"); //$NON-NLS-1$
		}
		// while ((p = sb.indexOf("&")) >= 0) { //$NON-NLS-1$
		// sb.deleteCharAt(p).insert(p,"&amp;"); //$NON-NLS-1$
		// }
		return stringBuilder.toString();
	}

}
