/**
 * 
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;


/**
 * @author Erwin
 */
final class TextAreaRenderer extends Renderer {

	/**
	 * 
	 */
	private static Renderer instance = new TextAreaRenderer();

	/**
	 * @return
	 */
	static Renderer getInstance ( ) {
		return instance;
	}

	/**
	 * Creates the TextAreaRenderer
	 * 
	 */
	private TextAreaRenderer ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#emptyHTML(be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getEmptyHTML (PresentationField presentationField, Locale locale) {
		if (presentationField.isInputEnabled()) {
			return "<TEXTAREA name=\"" + presentationField.getName() + "\" rows=\"5\" cols=\"80\" size=\"99%\"" + getHTMLTabIndexSpec(presentationField) + "></TEXTAREA>"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
		} else {
			return ""; //$NON-NLS-1$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#renderHTML(be.erwinsmout.WAAR.WaarValue, be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction, be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getHTML (WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		if (presentationField.isInputEnabled()) {
			return "<TEXTAREA name=\"" + presentationField.getName() + "\" rows=\"5\" cols=\"80\" size=\"99%\"" + getHTMLTabIndexSpec(presentationField) + ">" + presentationFieldValue.toWAARString(userFunction.getUserData()) + "</TEXTAREA>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		} else {
			return ""; //$NON-NLS-1$
		}
	}
}
