/*
 * Created on 16-aug-2008
 */
package be.WAAR.PresentationLayer;

import java.io.*;

/**
 * @author Erwin Smout
 */
class UDBInputStream extends FilterInputStream {
	/**
	 * Comment for <code>mask</code>
	 */
	private static final int[] mask = new int[] { 0, 3, 15 };

	/**
	 * Comment for <code>bits</code>
	 */
	private int bits = 0;

	/**
	 * Comment for <code>buffer</code>
	 */
	private int buffer = 0;

	/**
	 * Comment for <code>EOF</code>
	 */
	private boolean EOF = false;

	/**
	 * @param f
	 * @throws FileNotFoundException
	 */
	UDBInputStream (File f) throws FileNotFoundException {
		super(new FileInputStream(f));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.InputStream#available()
	 */
	public int available ( ) throws IOException {
		return (6 * super.available() + bits) / 8;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.InputStream#mark(int)
	 */
	public synchronized void mark (int readlimit) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.InputStream#markSupported()
	 */
	public boolean markSupported ( ) {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.InputStream#read()
	 */
	public int read ( ) throws IOException {
		while (bits < 8 && !EOF) {
			int b = super.read(); // range [95-32] or -1 at EOF
			if (b >= 0) {
				if (b < 32 || b > 95) {
					throw new IOException("Invalid byte " + Integer.toHexString(b)); //$NON-NLS-1$
				}
				b = 95 - b; // range [0-63]
				buffer = (buffer << 6) | b;
				bits += 6;
			} else {
				EOF = true;
			}
		}

		int ret;
		if (bits >= 8) {
			// bits leaves with 8, 10 or 12
			bits -= 8;
			// remaining significant bits in buffer 0, 2 or 4
			ret = buffer >> bits;
			buffer &= mask[bits >> 1];
		} else {
			// Means that EOF has been reached
			// The only bits we still have are the padded bits we added to indicate which padding was done.
			// These aren't bits of the real data, so we must return -1 to indicate EOF
			ret = -1;
		}

		return ret;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.InputStream#read(byte[], int, int)
	 */
	public int read (byte[] b, int off, int len) throws IOException {
		if (EOF) {
			return -1;
		}
		if (len < 1) {
			return 0;
		}
		int wrkoff = off;
		boolean cont = true;
		int c = 0;
		do {
			byte byteRead = (byte) read();
			if (byteRead >= 0) {
				b[wrkoff++] = byteRead;
				c++;
			} else {
				cont = false;
			}
		} while (cont);
		return c > 0 ? c : -1;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.InputStream#reset()
	 */
	public synchronized void reset ( ) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.InputStream#skip(long)
	 */
	public long skip (long n) {
		throw new UnsupportedOperationException();
	}
}
