/*
 * Created on 16-aug-2008
 */
package be.WAAR.PresentationLayer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

/**
 * @author Erwin Smout
 */
class UDBOutputStream extends FilterOutputStream {

	/**
	 * Comment for <code>mask</code>
	 */
	private static final int[] mask = new int[] { 0, 3, 15, 63 };

	/**
	 * The number of significant bits cached in buffer
	 */
	private int bits = 0;

	/**
	 * The buffer holding the set of bits not yet written
	 */
	private int buffer = 0;

	/**
	 * @param f
	 * @throws FileNotFoundException
	 */
	UDBOutputStream (File f) throws FileNotFoundException {
		super(new FileOutputStream(f));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.OutputStream#close()
	 */
	public void close ( ) throws IOException {
		// write last remaining bits
		if (bits > 0) {
			// two cases : 4 remaining bits or 2
			// shift those as far as possible
			buffer = buffer << (6 - bits);
			// mark the byte with the bit count in the last two bits
			buffer |= (bits >> 1); // 10 for four bits, 01 for two bits
			buffer = 95 - buffer;
			super.write(buffer);
		}

		// now flush and close
		super.close();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.OutputStream#write(int)
	 */
	public void write (int b) throws IOException {
		buffer = (buffer << 8) | (b & 0x000000ff);
		bits += 8;
		// bits now 12, 10 or 8
		while (bits >= 6) {
			bits -= 6;
			// bits now 6, 4 or 2 (and in case of 6, 0 the second time round)
			int writeb = buffer >> bits; // Always leaves 6 bits ===> range [0-63]
			writeb = 95 - writeb; // range now [95-32]
			super.write(writeb);
			buffer &= mask[bits >> 1];
		}
		// bits now 4, 2 or 0
	}
}
