/*
 * Created on 29-jan-2008
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
public class UnexpectedPresentationToProcessException extends WaarException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7655431009280295968L;

	/**
	 * Creates the exception object
	 * 
	 * @param presentationName
	 *            The name of the presentation that the doPresentationLogic encountered and did not expect
	 * @param locale
	 */
	public UnexpectedPresentationToProcessException (String presentationName, Locale locale) {
		super(MyMessageFormat.format(I18N.getString(locale, "UnexpectedPresentationToProcessException.Text"), new String[] { presentationName })); //$NON-NLS-1$
	}
}
