package be.WAAR.PresentationLayer;

import java.util.HashMap;

/**
 * UserSession objects hold all the information regarding a user session.
 * 
 * @author Erwin
 */
class UserSession {

	/**
	 * The map that stores the session context data.
	 */
	private HashMap<String, Object> contextData = new HashMap<String, Object>();

	/**
	 * The session's presentation function stack
	 */
	private PresentationFunctionStack functionStack;

	/**
	 * The session ID
	 */
	private long sessionID;

	/**
	 * The session verification token
	 */
	private long sessionVerificationToken;

	/**
	 * The UserData object holding all the information regarding the user that is running this session
	 */
	private UserData userdata;

	/**
	 * Creates a new UserSession object and assigns it the given session ID.
	 * 
	 * @param sessionID
	 *            The ID for this new session
	 */
	UserSession (long sessionID) {
		this.sessionID = sessionID;
		sessionVerificationToken = System.currentTimeMillis() ^ sessionID;
		functionStack = new PresentationFunctionStack();
	}

	/**
	 * Retrieves an object from the user session context
	 * 
	 * @param name
	 *            The name under which something was saved in the context
	 * @return The object saved under the given name
	 */
	Object getFromContext (String name) {
		return contextData.get(name);
	}

	/**
	 * Gets the session's function stack
	 * 
	 * @return the session's function stack
	 */
	PresentationFunctionStack getFunctionStack ( ) {
		return functionStack;
	}

	/**
	 * Gets the session ID
	 * 
	 * @return the session ID
	 */
	long getSessionID ( ) {
		return sessionID;
	}

	/**
	 * Gets the session verification token
	 * 
	 * @return the session verification token
	 */
	long getSessionVerificationToken ( ) {
		return sessionVerificationToken;
	}

	/**
	 * Gets the UserData object
	 * 
	 * @return the UserData object
	 */
	UserData getUserdata ( ) {
		return userdata;
	}

	/**
	 * Saves an object in the user session context
	 * 
	 * @param name
	 *            The name under which something should be saved in the context
	 * @param o
	 *            The object to save under the given name
	 */
	void saveInContext (String name, Object o) {
		contextData.put(name, o);
	}

	/**
	 * Sets the UserData object
	 * 
	 * @param userData
	 *            The UserData object to set
	 */
	void setUserData (UserData userData) {
		this.userdata = userData;
	}
}
