/**
 * 
 */
package be.WAAR.PresentationLayer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;


/**
 * @author Erwin
 * 
 */
final class VariableColumnListRenderer extends Renderer {

	/**
	 * 
	 */
	private static Renderer instance = new VariableColumnListRenderer();

	/**
	 * @return
	 */
	static Renderer getInstance ( ) {
		return instance;
	}

	/**
	 * Creates the VariableColumnListRenderer
	 * 
	 */
	private VariableColumnListRenderer ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#emptyHTML(be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getEmptyHTML (PresentationField presentationField, Locale locale) {
		return ""; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#renderHTML(be.erwinsmout.WAAR.WaarValue, be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction, be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getHTML (WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		DynamicColumnListValue dynamicColumnListValue = (DynamicColumnListValue) presentationFieldValue;
		LinkedList<String> columnList = dynamicColumnListValue.getColumnList();
		StringBuilder fieldHtml = new StringBuilder(30 * dynamicColumnListValue.getRowList().size() * columnList.size());

		int columnCount = Math.max(columnList.size(), 1);
		int columnWidthPercent = 100 / columnCount;
		fieldHtml.append("<TR>"); //$NON-NLS-1$
		Iterator<String> i_columnList = columnList.iterator();
		while (i_columnList.hasNext()) {
			String columnName = i_columnList.next();
			fieldHtml.append("<TH width=\"").append(columnWidthPercent).append("%\">").append(columnName).append("</TH>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		fieldHtml.append("</TR>"); //$NON-NLS-1$

		LinkedList<HashMap<String, WaarValue>> rowList = dynamicColumnListValue.getRowList();
		// iterate over the all the entries in the list
		Iterator<HashMap<String, WaarValue>> i_rowList = rowList.iterator();
		while (i_rowList.hasNext()) {
			// get the valuemap that holds the row
			HashMap<String, WaarValue> row = i_rowList.next();
			StringBuffer rowHtml = new StringBuffer("<TR>"); //$NON-NLS-1$
			// reset the column iterator
			i_columnList = columnList.iterator();
			while (i_columnList.hasNext()) {
				String columnName = i_columnList.next();
				WaarValue entryColumnValue = row.get(columnName);
				if (entryColumnValue != null) {
					if (entryColumnValue instanceof GenericStringValue) {
						rowHtml.append("<TD>" + ((GenericStringValue) entryColumnValue).getString() + "</TD>"); //$NON-NLS-1$ //$NON-NLS-2$
					} else {
						rowHtml.append("<TD><TABLE border=\"1\" width=\"100%\"><TBODY>" + getHTML(entryColumnValue, userFunction, presentationField, locale) + "</TBODY></TABLE></TD>"); //$NON-NLS-1$ //$NON-NLS-2$
					}
				} else {
					rowHtml.append("<TD> </TD>"); //$NON-NLS-1$
				}
			}
			rowHtml.append("</TR>"); //$NON-NLS-1$
			fieldHtml.append(rowHtml);
		}

		return fieldHtml.toString();
	}
}
