/*
 * Created on 10-sep-2007
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
public class WAARApplicationException extends WaarException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5310263254754854641L;

	/**
	 * Creates the exception object, using the generic application error message text, which includes the name of the root cause's exception type, and its message text.
	 * 
	 * @param e
	 *            The exception that caused this exception to be thrown
	 * @param locale
	 *            The locale in which to set the message text
	 */
	public WAARApplicationException (Exception e, Locale locale) {
		super(MyMessageFormat.format(I18N.getString(locale, "WAARApplicationException.Text"), new String[] { e.getMessage(), e.getClass().getName() })); //$NON-NLS-1$
	}

	/**
	 * Creates the WAARApplicationException
	 * 
	 * @param localeMessageText
	 */
	public WAARApplicationException (String localeMessageText) {
		super(localeMessageText);
	}
}