package be.WAAR.webclient;

import java.util.*;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.ListValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;

/**
 * The AttributeTypePoolOverview displays a list of types on the attribute pool
 * 
 * @author Erwin
 */
public class AttributeTypePoolOverview extends OnLinePresentationFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#startFunction()
	 */
	public void doInitialLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		ListValue lv = new ListValue("ATTRIBUTETYPELIST"); //$NON-NLS-1$
		HashMap<String, PresentationType> atpool = Architecture.getAttributeTypePool().getPool();
		synchronized (atpool) {
			Iterator<String> i = atpool.keySet().iterator();
			while (i.hasNext()) {
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put("NAME", new GenericStringValue(i.next())); //$NON-NLS-1$
				lv.append(m);
			}
		}
		setPresentationValue("ATTRIBUTETYPELIST", lv); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return "Manage Attribute Pool"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}
