package be.WAAR.webclient;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;

/**
 * AttributeTypePoolRemove is the Function through which an AttributeType can be removed from the Pool
 * 
 * @version 1.0
 * @author Erwin
 */
public class AttributeTypePoolRemove extends OnLinePresentationFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#startFunction()
	 */
	public void doInitialLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) {
		Architecture.getAttributeTypePool().remove(((GenericStringValue) getPresentationValue("NAME")).getString()); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return "Remove an AttributeType from its Pool"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}
