package be.WAAR.webclient;

import java.util.*;
import java.util.Map.Entry;

import javax.naming.*;
import javax.sql.DataSource;

import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.ListValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.UnspecifiedApplicationException;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;


/**
 * ContextOverview displays an overview of InitialContext, its properties and its contents
 * 
 * @author Erwin
 */
public class ContextOverview extends OnLinePresentationFunction {

	/**
	 * 
	 */
	private static final String CLASS = "CLASS"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String NAME = "NAME"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String VALUE = "VALUE"; //$NON-NLS-1$

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#startFunction()
	 */
	public void doInitialLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {

		try {
			InitialContext initialContext = new InitialContext();
			setPresentationValue("TOSTRING", initialContext.toString()); //$NON-NLS-1$

			ListValue lv_initialContextEnvironment = new ListValue("INITIALCONTEXTENVIRONMENT"); //$NON-NLS-1$
			Hashtable<?, ?> initialContextEnvironment = initialContext.getEnvironment();

			Iterator<?> i_initialContextEnvironment = initialContextEnvironment.entrySet().iterator();
			while (i_initialContextEnvironment.hasNext()) {
				Map.Entry<?, ?> me = (Entry<?, ?>) i_initialContextEnvironment.next();
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put(NAME, new GenericStringValue(me.getKey().toString()));
				m.put(CLASS, new GenericStringValue(me.getValue().getClass().getName()));
				m.put(VALUE, new GenericStringValue(me.getValue().toString()));
				lv_initialContextEnvironment.append(m);
			}
			setPresentationValue("INITIALCONTEXTENVIRONMENT", lv_initialContextEnvironment); //$NON-NLS-1$

			ListValue lv_initialContextNamingEnumeration = new ListValue("INITIALCONTEXTNAMINGENUMERATION"); //$NON-NLS-1$
			NamingEnumeration<NameClassPair> initialContextNamingEnumeration = initialContext.list("java:comp/env"); //$NON-NLS-1$

			while (initialContextNamingEnumeration.hasMore()) {
				NameClassPair initialContextNameClassPair = initialContextNamingEnumeration.next();
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put(NAME, new GenericStringValue(initialContextNameClassPair.getName()));
				m.put(CLASS, new GenericStringValue(initialContextNameClassPair.getClassName()));
				m.put(VALUE, new GenericStringValue("")); //$NON-NLS-1$
				lv_initialContextNamingEnumeration.append(m);

			}
			setPresentationValue("INITIALCONTEXTNAMINGENUMERATION", lv_initialContextNamingEnumeration); //$NON-NLS-1$

			Context envContext = (Context) initialContext.lookup("java:comp/env"); //$NON-NLS-1$
			Hashtable<?, ?> envContextEnvironment = envContext.getEnvironment();
			ListValue lv_envContextEnvironment = new ListValue("ENVCONTEXTENVIRONMENT"); //$NON-NLS-1$

			Iterator<?> i_envContextEnvironment = envContextEnvironment.entrySet().iterator();
			while (i_envContextEnvironment.hasNext()) {
				Map.Entry<?, ?> me = (Entry<?, ?>) i_envContextEnvironment.next();
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put(NAME, new GenericStringValue(me.getKey().toString()));
				m.put(CLASS, new GenericStringValue(me.getValue().getClass().getName()));
				m.put(VALUE, new GenericStringValue(me.getValue().toString()));
				lv_envContextEnvironment.append(m);
			}
			setPresentationValue("ENVCONTEXTENVIRONMENT", lv_envContextEnvironment); //$NON-NLS-1$

			ListValue lv_envContextNamingEnumeration = new ListValue("ENVCONTEXTNAMINGENUMERATION"); //$NON-NLS-1$
			NamingEnumeration<NameClassPair> envContextNamingEnumeration = envContext.list("jdbc"); //$NON-NLS-1$

			while (envContextNamingEnumeration.hasMore()) {
				NameClassPair envContextNameClassPair = envContextNamingEnumeration.next();
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put(NAME, new GenericStringValue(envContextNameClassPair.getName()));
				m.put(CLASS, new GenericStringValue(envContextNameClassPair.getClassName()));
				m.put(VALUE, new GenericStringValue("")); //$NON-NLS-1$
				lv_envContextNamingEnumeration.append(m);

			}
			setPresentationValue("ENVCONTEXTNAMINGENUMERATION", lv_envContextNamingEnumeration); //$NON-NLS-1$

			Context jdbcContext = (Context) envContext.lookup("jdbc"); //$NON-NLS-1$
			Hashtable<?, ?> jdbcContextEnvironment = jdbcContext.getEnvironment();
			ListValue lv_jdbcContextEnvironment = new ListValue("JDBCCONTEXTENVIRONMENT"); //$NON-NLS-1$

			Iterator<?> i_jdbcContextEnvironment = jdbcContextEnvironment.entrySet().iterator();
			while (i_jdbcContextEnvironment.hasNext()) {
				Map.Entry<?, ?> me = (Entry<?, ?>) i_jdbcContextEnvironment.next();
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put(NAME, new GenericStringValue(me.getKey().toString()));
				m.put(CLASS, new GenericStringValue(me.getValue().getClass().getName()));
				m.put(VALUE, new GenericStringValue(me.getValue().toString()));
				lv_jdbcContextEnvironment.append(m);
			}
			setPresentationValue("JDBCCONTEXTENVIRONMENT", lv_jdbcContextEnvironment); //$NON-NLS-1$

			ListValue lv_jdbcContextNamingEnumeration = new ListValue("JDBCCONTEXTNAMINGENUMERATION"); //$NON-NLS-1$
			NamingEnumeration<NameClassPair> jdbcContextNamingEnumeration = jdbcContext.list("SIRA_PRISE"); //$NON-NLS-1$

			while (jdbcContextNamingEnumeration.hasMore()) {
				NameClassPair jdbcContextNameClassPair = jdbcContextNamingEnumeration.next();
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put(NAME, new GenericStringValue(jdbcContextNameClassPair.getName()));
				m.put(CLASS, new GenericStringValue(jdbcContextNameClassPair.getClassName()));
				m.put(VALUE, new GenericStringValue("")); //$NON-NLS-1$
				lv_jdbcContextNamingEnumeration.append(m);

			}
			setPresentationValue("JDBCCONTEXTNAMINGENUMERATION", lv_jdbcContextNamingEnumeration); //$NON-NLS-1$

			Context sirapriseContext = (Context) jdbcContext.lookup("SIRA_PRISE"); //$NON-NLS-1$
			Hashtable<?, ?> sirapriseContextEnvironment = sirapriseContext.getEnvironment();
			ListValue lv_sirapriseContextEnvironment = new ListValue("SIRAPRISECONTEXTENVIRONMENT"); //$NON-NLS-1$

			Iterator<?> i_sirapriseContextEnvironment = sirapriseContextEnvironment.entrySet().iterator();
			while (i_sirapriseContextEnvironment.hasNext()) {
				Map.Entry<?, ?> me = (Entry<?, ?>) i_sirapriseContextEnvironment.next();
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put(NAME, new GenericStringValue(me.getKey().toString()));
				m.put(CLASS, new GenericStringValue(me.getValue().getClass().getName()));
				m.put(VALUE, new GenericStringValue(me.getValue().toString()));
				lv_sirapriseContextEnvironment.append(m);
			}
			setPresentationValue("SIRAPRISECONTEXTENVIRONMENT", lv_sirapriseContextEnvironment); //$NON-NLS-1$

			ListValue lv_sirapriseContextNamingEnumeration = new ListValue("SIRAPRISECONTEXTNAMINGENUMERATION"); //$NON-NLS-1$
			NamingEnumeration<NameClassPair> sirapriseContextNamingEnumeration = sirapriseContext.list(""); //$NON-NLS-1$

			while (sirapriseContextNamingEnumeration.hasMore()) {
				NameClassPair sirapriseContextNameClassPair = sirapriseContextNamingEnumeration.next();
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put(NAME, new GenericStringValue(sirapriseContextNameClassPair.getName()));
				m.put(CLASS, new GenericStringValue(sirapriseContextNameClassPair.getClassName()));
				m.put(VALUE, new GenericStringValue("")); //$NON-NLS-1$
				lv_sirapriseContextNamingEnumeration.append(m);

			}
			setPresentationValue("SIRAPRISECONTEXTNAMINGENUMERATION", lv_sirapriseContextNamingEnumeration); //$NON-NLS-1$

			int port = ((Integer) sirapriseContext.lookup("port")).intValue(); //$NON-NLS-1$
			String host = (String) sirapriseContext.lookup("host"); //$NON-NLS-1$
			DataSource DataSource = (DataSource) sirapriseContext.lookup("DataSource"); //$NON-NLS-1$

			setPresentationValue("HOST", host); //$NON-NLS-1$
			setPresentationValue("PORT", port); //$NON-NLS-1$
			setPresentationValue("DATASOURCE", DataSource.toString()); //$NON-NLS-1$

		} catch (NamingException e) {
			throw new UnspecifiedApplicationException(e, getUserLocale());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return "View Application Context"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}
