package be.WAAR.webclient;

import java.util.*;
import java.util.Map.Entry;

import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.ListValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;

/**
 * The AttributeTypePoolOverview displays a list of types on the attribute pool
 * 
 * @author Erwin
 */
public class PropertiesOverview extends OnLinePresentationFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#startFunction()
	 */
	public void doInitialLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		ListValue lv = new ListValue("PROPERTIESLIST"); //$NON-NLS-1$
		Properties properties = System.getProperties();
		synchronized (properties) {
			Iterator<Entry<Object, Object>> i = properties.entrySet().iterator();
			while (i.hasNext()) {
				Entry<Object, Object> me = i.next();
				String propertyName = (String) me.getKey();
				String propertyValue = (String) me.getValue();
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put("NAME", new GenericStringValue(propertyName)); //$NON-NLS-1$
				m.put("VALUE", new GenericStringValue(propertyValue)); //$NON-NLS-1$
				lv.append(m);
			}
		}
		setPresentationValue("PROPERTIESLIST", lv); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return "View System Properties"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}
