package be.WAAR.webclient;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.GenericTimeStampValue;
import be.WAAR.PresentationLayer.ListValue;
import be.WAAR.PresentationLayer.LogicalValue;
import be.WAAR.PresentationLayer.UserProperties;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;


/**
 * @author Erwin
 */
public class UsersDelete extends UsersFunction {

	/**
	 * Comment for <code>leave</code>
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedUser ( ) throws WaarException {
		WaarValue wv_userID = getPresentationValue("USERID"); //$NON-NLS-1$
		String userID = ((GenericStringValue) wv_userID).getString().trim();

		UserProperties userProperties = Architecture.getUserProperties(userID, getUserLocale());

		// switch from 'select relvar' presentation to 'manage some particular relvar's details' presentation
		setPresentation("UsersDeleteConfirm"); //$NON-NLS-1$
		setPresentationValue("USERID", wv_userID); //$NON-NLS-1$
		setPresentationValue("DISABLED", new LogicalValue(userProperties.isDisabled())); //$NON-NLS-1$
		setPresentationValue("PWCHANGEREQUIRED", new LogicalValue(userProperties.isPasswordToBeChangedAtNextLogon())); //$NON-NLS-1$
		setPresentationValue("LANGUAGE", userProperties.getLanguage()); //$NON-NLS-1$

		TreeSet<Long> suspiciousLogonAttemptTimes = userProperties.getSuspiciousLogonAttemptTimes();
		ListValue wv_pwFailures = new ListValue("PWFAILURES"); //$NON-NLS-1$
		Iterator<Long> i_suspiciousLogonAttemptTimes = suspiciousLogonAttemptTimes.iterator();
		while (i_suspiciousLogonAttemptTimes.hasNext()) {
			long suspiciousLogonAttemptTime = i_suspiciousLogonAttemptTimes.next().longValue();
			GenericTimeStampValue wv_suspiciousLogonAttemptTime = new GenericTimeStampValue(suspiciousLogonAttemptTime);
			HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
			m.put("PASSWORDFAILURE", wv_suspiciousLogonAttemptTime); //$NON-NLS-1$
			wv_pwFailures.append(m);
		}
		setPresentationValue("PWFAILURES", wv_pwFailures); //$NON-NLS-1$

		saveInFunctionContext("USERID", wv_userID); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		if (getPresentationValue("USERID") != null) { //$NON-NLS-1$
			processSelectedUser();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase("USERSSELECT")) { //$NON-NLS-1$
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedUser();
		} else {
			WaarValue wv_userID = (WaarValue) getFromFunctionContextMandatory("USERID"); //$NON-NLS-1$
			String userID = ((GenericStringValue) wv_userID).getString().trim();

			Architecture.removeWaarUser(userID, getUserData().getLocale());
			leave = true;
			// Modifications to screen currently not supported
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return "UsersSelect"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return "Delete a WAAR User ID"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}
