package be.WAAR.webclient;

import java.util.*;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.ListValue;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;


/**
 * @version 1.0
 * @author Erwin
 */
public class UsersOverview extends UsersFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		ListValue lv = new ListValue("USERLIST"); //$NON-NLS-1$
		Set<String> userIDs = Architecture.getWaarUsers().keySet();
		synchronized (userIDs) {
			Iterator<String> i = userIDs.iterator();
			while (i.hasNext()) {
				HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
				m.put("USERID", new GenericStringValue(i.next())); //$NON-NLS-1$
				lv.append(m);
			}
		}
		setPresentationValue("USERLIST", lv); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.PresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return "View the WAAR user list"; //$NON-NLS-1$
	}
}
