* Charset=windows-1252
assert constrainedtype,constrainedtype( |>
tuple(typename(nr_emp_t)basetype(int)sp_expression(and\(gt\(parameter\(v\(int\)\),int\(999\)\),gt\(int\(10000\),parameter\(v\(int\)\)\)\))) |>
tuple(typename(nr_dept_t)basetype(int)sp_expression(and\(gt\(parameter\(v\(int\)\),int\(0\)\),gt\(int\(100\),parameter\(v\(int\)\)\)\))) |>
)
cmd(assert attribute,attribute( |>
tuple(attributename(nr_emp)typename(nr_emp_t)) |>
tuple(attributename(nm_emp)typename(name)) |>
tuple(attributename(nm_job)typename(name)) |>
tuple(attributename(dt_born)typename(date)) |>
tuple(attributename(dt_hired)typename(date)) |>
tuple(attributename(nr_sgrd)typename(int)) |>
tuple(attributename(am_sal_mthly)typename(decimal)) |>
tuple(attributename(nm_user)typename(name)) |>
tuple(attributename(nr_dept)typename(nr_dept_t)) |>
tuple(attributename(nr_emp_mgr)typename(nr_emp_t)) |>
tuple(attributename(am_sls_trgt)typename(decimal)) |>
tuple(attributename(am_comm)typename(decimal)) |>
tuple(attributename(dt_left)typename(date)) |>
tuple(attributename(tx_cmmnt)typename(string)) |>
tuple(attributename(nm_dept)typename(name)) |>
tuple(attributename(nm_loc)typename(name)) |>
tuple(attributename(am_lower_limit)typename(decimal)) |>
tuple(attributename(am_upper_limit)typename(decimal)) |>
tuple(attributename(am_bonus)typename(decimal)) |>
tuple(attributename(cd_crs)typename(name)) |>
tuple(attributename(tx_descr)typename(string)) |>
tuple(attributename(nm_categ)typename(name)) |>
tuple(attributename(qy_days)typename(int)) |>
tuple(attributename(dt_start)typename(date)) |>
tuple(attributename(cd_stat)typename(name)) |>
tuple(attributename(qy_prtcp_max)typename(int)) |>
tuple(attributename(nr_emp_trnr)typename(nr_emp_t)) |>
tuple(attributename(nr_emp_stdnt)typename(nr_emp_t)) |>
tuple(attributename(cd_eval)typename(int)) |>
tuple(attributename(dt_until)typename(date)) |>
)) |>
cmd(assert attributelogicallength,attributelogicallength( |>
tuple(attributename(nm_emp)logicallength(26)) |>
tuple(attributename(nm_job)logicallength(9)) |>
tuple(attributename(nm_user)logicallength(15)) |>
tuple(attributename(tx_cmmnt)logicallength(60)) |>
tuple(attributename(nm_dept)logicallength(12)) |>
tuple(attributename(nm_loc)logicallength(14)) |>
tuple(attributename(cd_crs)logicallength(6)) |>
tuple(attributename(tx_descr)logicallength(40)) |>
tuple(attributename(nm_categ)logicallength(3)) |>
tuple(attributename(cd_stat)logicallength(4)) |>
))
commit
cmd( |>
assert relvar,relvar( |>
tuple(relvarname(jobs)relvarpredicate(nm_job is a possible job.)) |>
tuple(relvarname(emp)relvarpredicate(the employee with employee number nr_emp has name nm_emp, a monthly salary of am_sal_mthly eur in salary grade nr_sgrd, is assigned account nm_user, reports to employee nr_emp_mgr and works for department number nr_dept.)) |>
tuple(relvarname(president)relvarpredicate(the employee with employee number nr_emp has name nm_emp, a monthly salary of am_sal_mthly eur, and is the president of the company.)) |>
tuple(relvarname(srep)relvarpredicate(sales representative nr_emp has an annual sales target of am_sls_trgt eur and a yearly commission of am_comm eur.)) |>
tuple(relvarname(term)relvarpredicate(employee nr_emp has resigned or was fired on dt_left for reason tx_cmmnt.)) |>
tuple(relvarname(dept)relvarpredicate(department nr_dept is named nm_dept, is located at nm_loc, and is managed by employee nr_emp_mgr.)) |>
tuple(relvarname(grd)relvarpredicate(salary grade nr_sgrd has a lower monthly salary limit of am_lower_limit eur, an upper limit of am_upper_limit eur, and a maximum yearly bonus of am_bonus eur.)) |>
tuple(relvarname(crs)relvarpredicate(course cd_crs is labeled tx_descr, belongs to course category nm_categ, and lasts qy_days days.)) |>
tuple(relvarname(offr)relvarpredicate(the offering of course cd_crs starting on dt_start has a maximum capacity of qy_prtcp_max attendees, is offered at nm_loc, and has status cd_stat.)) |>
tuple(relvarname(offrtrn)relvarpredicate(nr_emp_trnr is the assigned trainer for the offering of course cd_crs starting on dt_start.)) |>
tuple(relvarname(reg)relvarpredicate(employee nr_emp_stdnt has registered for the offering of course cd_crs starting on dt_start.)) |>
tuple(relvarname(offreval)relvarpredicate(nr_emp_stdnt rated course cd_crs \(that started on dt_start\) with the score cd_eval.)) |>
tuple(relvarname(hist)relvarpredicate(at date dt_until, department or salary have changed for employee nr_emp.  prior to that date, his department was nr_dept and his salary am_sal_mthly.)) |>
) |>
) |>
cmd( |>
assert key,key( |>
tuple(relvarname(emp)errorcode(115004)) tuple(relvarname(emp)errorcode(115104)) |>
tuple(relvarname(president)errorcode(115005)) |>
tuple(relvarname(srep)errorcode(115007)) |>
tuple(relvarname(term)errorcode(115010)) |>
tuple(relvarname(dept)errorcode(115011)) tuple(relvarname(dept)errorcode(115012)) |>
tuple(relvarname(grd)errorcode(115016)) tuple(relvarname(grd)errorcode(115017)) tuple(relvarname(grd)errorcode(115018)) |>
tuple(relvarname(crs)errorcode(115022)) |>
tuple(relvarname(offr)errorcode(115024)) |>
tuple(relvarname(offrtrn)errorcode(115025)) tuple(relvarname(offrtrn)errorcode(115124)) |>
tuple(relvarname(reg)errorcode(115026)) |>
tuple(relvarname(offreval)errorcode(115126)) |>
tuple(relvarname(hist)errorcode(115028)) |>
) |>
)
commit
assert relvarattribute,relvarattribute( |>
tuple(relvarname(jobs)attributename(nm_job)) |>
tuple(relvarname(emp)attributename(nr_emp)) tuple(relvarname(emp)attributename(nm_emp)) |>
tuple(relvarname(emp)attributename(nm_job)) tuple(relvarname(emp)attributename(dt_born)) |>
tuple(relvarname(emp)attributename(dt_hired)) tuple(relvarname(emp)attributename(nr_sgrd)) |>
tuple(relvarname(emp)attributename(am_sal_mthly)) tuple(relvarname(emp)attributename(nm_user)) |>
tuple(relvarname(emp)attributename(nr_dept)) tuple(relvarname(emp)attributename(nr_emp_mgr)) |>
tuple(relvarname(president)attributename(nr_emp)) tuple(relvarname(president)attributename(nm_emp)) |>
tuple(relvarname(president)attributename(am_sal_mthly)) |>
tuple(relvarname(srep)attributename(nr_emp)) tuple(relvarname(srep)attributename(am_sls_trgt)) |>
tuple(relvarname(srep)attributename(am_comm)) |>
tuple(relvarname(term)attributename(nr_emp)) tuple(relvarname(term)attributename(dt_left)) |>
tuple(relvarname(term)attributename(tx_cmmnt)) |>
tuple(relvarname(dept)attributename(nr_dept)) tuple(relvarname(dept)attributename(nm_dept)) |>
tuple(relvarname(dept)attributename(nm_loc)) tuple(relvarname(dept)attributename(nr_emp_mgr)) |>
tuple(relvarname(grd)attributename(nr_sgrd)) tuple(relvarname(grd)attributename(am_bonus)) |>
tuple(relvarname(grd)attributename(am_lower_limit)) tuple(relvarname(grd)attributename(am_upper_limit)) |>
tuple(relvarname(crs)attributename(cd_crs)) tuple(relvarname(crs)attributename(tx_descr)) |>
tuple(relvarname(crs)attributename(nm_categ)) tuple(relvarname(crs)attributename(qy_days)) |>
tuple(relvarname(offr)attributename(cd_crs)) tuple(relvarname(offr)attributename(dt_start)) |>
tuple(relvarname(offr)attributename(cd_stat)) tuple(relvarname(offr)attributename(qy_prtcp_max)) |>
tuple(relvarname(offr)attributename(nm_loc)) |>
tuple(relvarname(offrtrn)attributename(nr_emp_trnr)) |>
tuple(relvarname(offrtrn)attributename(cd_crs)) tuple(relvarname(offrtrn)attributename(dt_start)) |>
tuple(relvarname(reg)attributename(nr_emp_stdnt)) tuple(relvarname(reg)attributename(cd_crs)) |>
tuple(relvarname(reg)attributename(dt_start)) |>
tuple(relvarname(offreval)attributename(nr_emp_stdnt)) tuple(relvarname(offreval)attributename(cd_crs)) |>
tuple(relvarname(offreval)attributename(dt_start)) tuple(relvarname(offreval)attributename(cd_eval)) |>
tuple(relvarname(hist)attributename(nr_emp)) tuple(relvarname(hist)attributename(dt_until)) |>
tuple(relvarname(hist)attributename(nr_dept)) tuple(relvarname(hist)attributename(am_sal_mthly)) |>
)
commit
assert keyattribute,keyattribute( |>
tuple(errorcode(115004)attributename(nr_emp)) |>
tuple(errorcode(115104)attributename(nm_user)) |>
tuple(errorcode(115007)attributename(nr_emp)) |>
tuple(errorcode(115010)attributename(nr_emp)) |>
tuple(errorcode(115011)attributename(nr_dept)) |>
tuple(errorcode(115012)attributename(nm_dept)) tuple(errorcode(115012)attributename(nm_loc)) |>
tuple(errorcode(115016)attributename(nr_sgrd)) |>
tuple(errorcode(115017)attributename(am_upper_limit)) |>
tuple(errorcode(115018)attributename(am_lower_limit)) |>
tuple(errorcode(115022)attributename(cd_crs)) |>
tuple(errorcode(115024)attributename(cd_crs)) tuple(errorcode(115024)attributename(dt_start)) |>
tuple(errorcode(115025)attributename(nr_emp_trnr)) tuple(errorcode(115025)attributename(dt_start)) |>
tuple(errorcode(115124)attributename(cd_crs)) tuple(errorcode(115124)attributename(dt_start)) |>
tuple(errorcode(115026)attributename(nr_emp_stdnt)) tuple(errorcode(115026)attributename(dt_start)) |>
tuple(errorcode(115126)attributename(nr_emp_stdnt)) tuple(errorcode(115126)attributename(dt_start)) |>
tuple(errorcode(115028)attributename(nr_emp)) tuple(errorcode(115028)attributename(dt_until)) |>
)
commit
assert tupleconstraint,tupleconstraint( |>
tuple(relvarname(emp)errorcode(115001)sp_expression(gt\(dt_hired,dateshift\(dt_born,int\(18\),int\(0\),int\(0\)\)\))) |>
tuple(relvarname(president)errorcode(115002)sp_expression(gt\(am_sal_mthly,decimal\(10000\)\))) |>
tuple(relvarname(emp)errorcode(115003)sp_expression(or\(not\(eq\(nm_job,name\(admin\)\)\),gt\(decimal\(5000\),am_sal_mthly\)\))) |>
tuple(relvarname(grd)errorcode(115014)sp_expression(gt\(am_upper_limit,plus\(am_lower_limit,decimal\(499.99999999999999\)\)\))) |>
tuple(relvarname(grd)errorcode(115015)sp_expression(gt\(am_lower_limit,am_bonus\))) |>
tuple(relvarname(crs)errorcode(115021)sp_expression(or\(not\(eq\(nm_categ,name\(bld\)\)\),gt\(int\(6\),qy_days\)\))) |>
tuple(relvarname(emp)errorcode(115081)sp_expression(gt\(am_sal_mthly,decimal\(0\)\))) |>
tuple(relvarname(srep)errorcode(115082)sp_expression(and\(gt\(am_sls_trgt,decimal\(9999\)\),gt\(decimal\(100000\),am_sls_trgt\)\))) |>
tuple(relvarname(srep)errorcode(115083)sp_expression(gt\(am_comm,decimal\(0\)\))) |>
tuple(relvarname(emp)errorcode(115084)sp_expression(not\(eq\(nr_emp,nr_emp_mgr\)\))) |>
tuple(relvarname(grd)errorcode(115085)sp_expression(and\(gt\(int\(100\),nr_sgrd\),gt\(nr_sgrd,int\(0\)\)\))) |>
tuple(relvarname(grd)errorcode(115086)sp_expression(gt\(am_bonus,decimal\(-0.000000000000000001\)\))) |>
tuple(relvarname(crs)errorcode(115087)sp_expression(or\(eq\(nm_categ,name\(dsg\)\),or\(eq\(nm_categ,name\(gen\)\),eq\(nm_categ,name\(bld\)\)\)\))) |>
tuple(relvarname(crs)errorcode(115088)sp_expression(and\(gt\(qy_days,int\(0\)\),gt\(int\(16\),qy_days\)\))) |>
tuple(relvarname(offr)errorcode(115089)sp_expression(or\(eq\(cd_stat,name\(conf\)\),or\(eq\(cd_stat,name\(canc\)\),eq\(cd_stat,name\(schd\)\)\)\))) |>
tuple(relvarname(offr)errorcode(115090)sp_expression(and\(gt\(int\(101\),qy_prtcp_max\),gt\(qy_prtcp_max,int\(5\)\)\))) |>
tuple(relvarname(offreval)errorcode(115091)sp_expression(and\(gt\(int\(10\),cd_eval\),gt\(cd_eval,int\(-1\)\)\))) |>
)
commit
assert databaseconstraint,databaseconstraint( |>
tuple(constraintlabel(R6 - A department that employs a manager should also employ an administrator.)errorcode(115106)sp_expression(minus\(project\(restrict\(emp,eq\(nm_job,name\(manager\)\)\),\(nr_dept\)\),project\(restrict\(emp,eq\(nm_job,name\(admin\)\)\),\(nr_dept\)\)\) )) |>
tuple(constraintlabel(R13 - No one can manage more than two departments.)errorcode(115113)sp_expression(restrict\(summarizeby\(extend\(dept,\(one\(int\(1\)\)\)\),\(nr_emp_mgr\),qy_dept_mangd\(plus\(one\)\)\),gt\(qy_dept_mangd,int\(2\)\)\) )) |>
tuple(constraintlabel(R20a - No grade can be completely contained within another.)errorcode(115120)sp_expression( restrict\(join\(grd,rename\(project\(grd,\(am_upper_limit,am_lower_limit,nr_sgrd\)\),\(am_lower_limit,oll,am_upper_limit,oul,nr_sgrd,ogrd\)\)\),and\(not\(eq\(nr_sgrd,ogrd\)\),contains\(decimalinterval\(begin\(am_lower_limit\)end\(am_upper_limit\)\),decimalinterval\(begin\(oll\)end\(oul\)\)\)\)\) )) |>
tuple(constraintlabel(R20b - Only one grade overlaps on the lower side.)errorcode(115121)sp_expression(restrict\(join\(grd,rename\(project\(grd,\(am_upper_limit,am_lower_limit\)\),\(am_lower_limit,oll,am_upper_limit,oul\)\),rename\(project\(grd,\(am_upper_limit,am_lower_limit\)\),\(am_lower_limit,oll2,am_upper_limit,oul2\)\)\),and\(gt\(am_lower_limit,oll\),and\(gt\(oll,oll2\),or\(eq\(oul2,am_lower_limit\),gt\(oul2,am_lower_limit\)\)\)\)\))) |>
tuple(constraintlabel(R20c - Only one grade has no overlapping lower grade.)errorcode(115122)sp_expression(restrict\(join\(project\(semiminus\(grd,project\(restrict\(join\(grd,rename\(project\(grd,\(am_lower_limit,am_upper_limit\)\),\(am_lower_limit,oll,am_upper_limit,oul\)\)\),and\(gt\(oul,am_lower_limit,\),gt\(am_lower_limit,oll\)\)\),\(am_lower_limit\)\)\),\(am_lower_limit\)\),rename\(project\(semiminus\(grd,project\(restrict\(join\(grd,rename\(project\(grd,\(am_lower_limit,am_upper_limit\)\),\(am_lower_limit,oll4,am_upper_limit,oul4\)\)\),and\(gt\(oul4,am_lower_limit,\),gt\(am_lower_limit,oll4\)\)\),\(am_lower_limit\)\)\),\(am_lower_limit\)\),\(am_lower_limit,sll\)\)\),not\(eq\(am_lower_limit,sll\)\)\))) |>
tuple(constraintlabel(R23 - Offerings with no assigned trainer are only allowed for cancelled or scheduled offerings.)errorcode(115123)sp_expression(restrict\(semiminus\(offr,project\(offrtrn,\(cd_crs,dt_start\)\)\),not\(or\(eq\(cd_stat,name\(canc\)\),eq\(cd_stat,name\(schd\)\)\)\)\) )) |>
tuple(constraintlabel(R29 - A change must have occurred in either salary or department at every history date.)errorcode(115129)sp_expression(semiminus\(restrict\(join\(hist,rename\(hist,\(dt_until,dt_until2\)\)\),gt\(dt_until2,dt_until\)\),project\(restrict\(join\(hist,rename\(hist,\(dt_until,dt_until2\)\),rename\(hist,\(dt_until,dt_until3,am_sal_mthly,am_sal_mthly3,nr_dept,nr_dept3\)\)\),and\(and\(gt\(dt_until2,dt_until3\),gt\(dt_until3,dt_until\)\),or\(not\(eq\(am_sal_mthly3,am_sal_mthly\)\),not\(eq\(nr_dept,nr_dept3\)\)\)\)\),\(nr_emp,dt_until,dt_until2\)\)\))) |>
tuple(constraintlabel(R30 - All employees must work for a known department.)errorcode(115130)sp_expression( semiminus\(emp,project\(dept,\(nr_dept\)\)\) )) |>
tuple(constraintlabel(R31 - A Department manager must be a known employee who is not an admin and has not left.)errorcode(115131)sp_expression( semiminus\(dept,rename\(minus\(project\(restrict\(emp,not\(eq\(nm_job,name\(admin\)\)\)\),\(nr_emp\)\),project\(term,\(nr_emp\)\)\),\(nr_emp,nr_emp_mgr\)\)\) )) |>
tuple(constraintlabel(R32 - Employees can only report to the president or a manager, and that manager cannot have left.)errorcode(115132)sp_expression( semiminus\(emp,minus\(rename\(union\(project\(restrict\(emp,eq\(nm_job,name\(manager\)\)\),\(nr_emp\)\),project\(president,nr_emp\)\),\(nr_emp,nr_emp_mgr\)\),rename\(project\(term,\(nr_emp\)\),\(nr_emp,nr_emp_mgr\)\)\)\) )) |>
tuple(constraintlabel(R33a - Only known employees can have left.)errorcode(115133)sp_expression( semiminus\(term,project\(emp,\(nr_emp\)\)\) )) |>
tuple(constraintlabel(R34 - Each employee has a known salary grade.)errorcode(115134)sp_expression( semiminus\(emp,project\(grd,\(nr_sgrd\)\)\) )) |>
tuple(constraintlabel(R35 - Each course offering must be for a known course.)errorcode(115135)sp_expression( semiminus\(offr,project\(crs,\(cd_crs\)\)\) )) |>
tuple(constraintlabel(R36 - Courses can only take place in locations where we have department.)errorcode(115136)sp_expression( semiminus\(offr,project\(dept,\(nm_loc\)\)\) )) |>
tuple(constraintlabel(R37 - The trainer in every course offering must be a known trainer.)errorcode(115137)sp_expression( semiminus\(offrtrn,rename\(project\(restrict\(emp,eq\(nm_job,name\(trainer\)\)\),\(nr_emp\)\),\(nr_emp,nr_emp_trnr\)\)\) )) |>
tuple(constraintlabel(R38 - Only known employees can register as a student for a course offering.)errorcode(115138)sp_expression( semiminus\(reg,rename\(project\(emp,\(nr_emp\)\),\(nr_emp,nr_emp_stdnt\)\)\) )) |>
tuple(constraintlabel(R39 - Each course registration is for a known course offering.)errorcode(115139)sp_expression( semiminus\(reg,project\(offr,\(cd_crs,dt_start\)\)\) )) |>
tuple(constraintlabel(R40 - Each history record is for a known employee.)errorcode(115140)sp_expression( semiminus\(hist,project\(emp,\(nr_emp\)\)\) )) |>
tuple(constraintlabel(R41 - Each history record is for a known department.)errorcode(115141)sp_expression( semiminus\(hist,project\(dept,\(nr_dept\)\)\) )) |>
tuple(constraintlabel(R42 - Salesreps must have both a target and a commission, and all sales targets must be for salesreps.)errorcode(115142)sp_expression( union\(minus\(project\(restrict\(emp,eq\(nm_job,name\(salesrep\)\)\),\(nr_emp\)\),project\(srep,\(nr_emp\)\)\),minus\(project\(srep,\(nr_emp\)\),project\(restrict\(emp,eq\(nm_job,name\(salesrep\)\)\),\(nr_emp\)\)\)\) )) |>
tuple(constraintlabel(R44 - Monthly salary must fall within assigned salary grade.)errorcode(115144)sp_expression( restrict\(join\(emp,grd\),or\(gt\(am_sal_mthly,am_upper_limit,\),gt\(am_lower_limit,am_sal_mthly\)\)\) )) |>
tuple(constraintlabel(R45 - Leave date must be after hire date.)errorcode(115145)sp_expression( restrict\(join\(emp,term\),or\(eq\(dt_hired,dt_left\),gt\(dt_hired,dt_left\)\)\) )) |>
tuple(constraintlabel(R46 - Salesreps cannot earn more than the employee they report to.)errorcode(115146)sp_expression( restrict\(join\(srep,emp,project\(rename\(emp,\(nr_emp_mgr,mgrmgr,nr_emp,nr_emp_mgr,am_sal_mthly,am_sal_mthly_mgr\)\),\(nr_emp_mgr,am_sal_mthly_mgr\)\)\),gt\(plus\(am_sal_mthly,am_comm\),am_sal_mthly_mgr\)\) )) |>
tuple(constraintlabel(R47 - Non-Salesreps cannot earn more than the employee they report to.)errorcode(115147)sp_expression( restrict\(join\(emp,project\(rename\(emp,\(nr_emp_mgr,mgrmgr,nr_emp,nr_emp_mgr,am_sal_mthly,am_sal_mthly_mgr\)\),\(nr_emp_mgr,am_sal_mthly_mgr\)\)\),and\(not\(eq\(nm_job,name\(salesrep\)\)\),gt\(am_sal_mthly,am_sal_mthly_mgr\)\)\) )) |>
tuple(constraintlabel(R48 - History records cannot be dated at or before hire date.)errorcode(115148)sp_expression( restrict\(join\(emp,hist\),or\(eq\(dt_hired,dt_until\),gt\(dt_hired,dt_until\)\)\) )) |>
tuple(constraintlabel(R49 - History records cannot be dated after leave date.)errorcode(115149)sp_expression( restrict\(join\(term,hist\),gt\(dt_until,dt_left\)\) )) |>
tuple(constraintlabel(R50 - One cannot register for course offerings in the first 28 days after hire date.)errorcode(115150)sp_expression( restrict\(join\(emp,rename\(reg,\(nr_emp_stdnt,nr_emp\)\)\),gt\(dateshift\(dt_hired,int\(0\),int\(0\),int\(28\)\),dt_start\)\) )) |>
tuple(constraintlabel(R51 - One cannot register for course offerings that extend beyond leave date.)errorcode(115151)sp_expression( restrict\(join\(term,rename\(reg,\(nr_emp_stdnt,nr_emp\)\),crs\),gt\(dateshift\(dt_start,int\(0\),int\(0\),qy_days\),dt_left\)\) )) |>
tuple(constraintlabel(R52 - One cannot register for overlapping course offerings.)errorcode(115152)sp_expression( restrict\(join\(extend\(join\(reg,project\(crs,\(cd_crs,qy_days\)\)\),\(pe_crs\(dateinterval\(begin\(dt_start\)end\(dateshift\(dt_start,int\(0\),int\(0\),qy_days\)\)\)\)\)\),rename\(extend\(join\(reg,project\(crs,\(cd_crs,qy_days\)\)\),\(pe_crs\(dateinterval\(begin\(dt_start\)end\(dateshift\(dt_start,int\(0\),int\(0\),qy_days\)\)\)\)\)\),\(cd_crs,cd_crs2,qy_days,qy_days2,dt_start,dt_start2\)\)\),not\(eq\(cd_crs,cd_crs2\)\)\) )) |>
tuple(constraintlabel(R53 - Trainer cannot teach courses before hire date.)errorcode(115153)sp_expression( restrict\(join\(emp,rename\(offrtrn,\(nr_emp_trnr,nr_emp\)\)\),gt\(dt_hired,dt_start\)\) )) |>
tuple(constraintlabel(R54 - Trainer cannot teach courses at or after leave date.)errorcode(115154)sp_expression( restrict\(join\(term,rename\(offrtrn,\(nr_emp_trnr,nr_emp\)\),crs\),gt\(dateshift\(dt_start,int\(0\),int\(0\),qy_days\),dt_left\)\) )) |>
tuple(constraintlabel(R55 - Trainers cannot register for offerings taught by themselves.)errorcode(115155)sp_expression( restrict\(join\(reg,offrtrn\),eq\(nr_emp_trnr,nr_emp_stdnt\)\) )) |>
tuple(constraintlabel(R56 - One cannot be assigned as trainer for overlapping course offerings.)errorcode(115156)sp_expression( restrict\(join\(extend\(join\(offrtrn,project\(crs,\(cd_crs,qy_days\)\)\),\(pe_crs\(dateinterval\(begin\(dt_start\)end\(dateshift\(dt_start,int\(0\),int\(0\),qy_days\)\)\)\)\)\),rename\(extend\(join\(offrtrn,project\(crs,\(cd_crs,qy_days\)\)\),\(pe_crs\(dateinterval\(begin\(dt_start\)end\(dateshift\(dt_start,int\(0\),int\(0\),qy_days\)\)\)\)\)\),\(cd_crs,cd_crs2,qy_days,qy_days2,dt_start,dt_start2\)\)\),not\(and\(eq\(cd_crs,cd_crs2\),eq\(dt_start,dt_start2\)\)\)\) )) |>
tuple(constraintlabel(R57 - One cannot be assigned as trainer for course offerings overlapping a course offering one has registered for.)errorcode(115157)sp_expression( join\(extend\(join\(offrtrn,project\(crs,\(cd_crs,qy_days\)\)\),\(pe_crs\(dateinterval\(begin\(dt_start\)end\(dateshift\(dt_start,int\(0\),int\(0\),qy_days\)\)\)\)\)\),rename\(extend\(join\(reg,project\(crs,\(cd_crs,qy_days\)\)\),\(pe_crs\(dateinterval\(begin\(dt_start\)end\(dateshift\(dt_start,int\(0\),int\(0\),qy_days\)\)\)\)\)\),\(cd_crs,cd_crs_reg,qy_days,qy_days_reg,dt_start,dt_start_reg,nr_emp_stdnt,nr_emp_trnr\)\)\) )) |>
tuple(constraintlabel(R58 - Department manager must work for a department he/she manages.)errorcode(115158)sp_expression( semiminus\(dept,project\(join\(dept,rename\(emp,\(nr_emp_mgr,mgrmgr,nr_emp,nr_emp_mgr\)\)\),\(nr_emp_mgr\)\)\) )) |>
tuple(constraintlabel(R61 - At least half of the course offerings taught by some trainer must be 'at home base'.)errorcode(115161)sp_expression( restrict\(ungroup\(ungroup\(extend\(extend\(group\(project\(join\(restrict\(offr,not\(eq\(cd_stat,name\(canc\)\)\)\),offrtrn,crs,project\(rename\(emp,\(nr_emp,nr_emp_trnr\)\),\(nr_emp_trnr,nr_dept\)\),rename\(dept,\(nm_loc,nm_loc_dept\)\)\),\(cd_crs,dt_start,nm_loc,cd_stat,qy_days,nr_dept,nm_loc_dept,nr_emp_trnr\)\),troffr\(cd_crs,dt_start,nm_loc,cd_stat,qy_days,nr_dept,nm_loc_dept\)\),locoffr\(restrict\(troffr,eq\(nm_loc,nm_loc_dept\)\)\)\),\(durall\(aggregate\(troffr,totdurall\(plus\(qy_days\)\)\)\)durlocal\(aggregate\(locoffr,totdurloc\(plus\(qy_days\)\)\)\)\)\),\(durall\)\),\(durlocal\)\),gt\(totdurall,plus\(totdurloc,totdurloc\)\)\) )) |>
tuple(constraintlabel(R63 - Number of registrations cannot exceed maximum number of participants.)errorcode(115163)sp_expression( restrict\(join\(summarizeby\(extend\(reg,one\(int\(1\)\)\),\(cd_crs,dt_start\),qy_prtcp\(plus\(one\)\)\),offrtrn,offr\),gt\(qy_prtcp,qy_prtcp_max\)\) )) |>
tuple(constraintlabel(R65 - Courses can only be taught by a trainer if he has been employed for over a year, or under very special conditions.)errorcode(115165)sp_expression( minus\(summarizeby\(project\(restrict\(join\(offrtrn,rename\(emp,\(nr_emp,nr_emp_trnr\)\)\),gt\(dateshift\(dt_hired,int\(1\),int\(0\),int\(0\)\),dt_start\)\),\(nr_emp_trnr,cd_crs,dt_start\)\),\(nr_emp_trnr,cd_crs\),dt_first\(min\(dt_start\)\)\),project\(restrict\(join\(rename\(reg,\(nr_emp_stdnt,nr_emp_ctrlt,dt_start,dt_first\)\),rename\(offrtrn,\(nr_emp_trnr,nr_emp_ctrlt,dt_start,dt_start_prec\)\),rename\(reg,\(dt_start,dt_start_prec,nr_emp_stdnt,nr_emp_trnr\)\)\),gt\(dt_first,dt_start_prec\)\),\(nr_emp_trnr,cd_crs,dt_first\)\)\) )) |>
tuple(constraintlabel(R73 - Each employee must have a known job.)errorcode(115173)sp_expression( semiminus\(emp,jobs\) )) |>
tuple(constraintlabel(R74 - Each course evaluation must be one from a student registered for that course offering.)errorcode(115174)sp_expression( semiminus\(offreval,reg\) )) |>
tuple(constraintlabel(R75 - No employee can be the president too.)errorcode(115175)sp_expression( intersect\(project\(emp,\(nr_emp\)\),project\(president,\(nr_emp\)\)\) )) |>
)
commit
cmd( |>
assert assignmentconstraint,assignmentconstraint( |>
tuple(constraintlabel(R66 - Monthly salary cannot decrease.)errorcode(115166)sp_expression( restrict\(join\(inserts\(emp\),transform\(deletes\(emp\),\(nr_emp,am_osal_mthly\(am_sal_mthly\)\)\)\),gt\(am_osal_mthly,am_sal_mthly\)\) )) |>
tuple(constraintlabel(R67 - New course offerings must have status 'scheduled'.)errorcode(115167)sp_expression( restrict\(semiminus\(inserts\(offr\),transform\(deletes\(offr\),\(cd_crs,dt_start\)\)\),not\(eq\(cd_stat,name\(schd\)\)\)\) )) |>
tuple(constraintlabel(R68 - Offering status codes can only change to 'cancelled' or from 'scheduled' to 'confirmed'.)errorcode(115168)sp_expression( restrict\(join\(inserts\(offr\),transform\(deletes\(offr\),\(cd_crs,dt_start,cd_stat_old\(cd_stat\)\)\)\),not\(or\(eq\(cd_stat,cd_stat_old\),or\(eq\(cd_stat,name\(canc\)\),and\(eq\(cd_stat,name\(conf\)\),eq\(cd_stat_old,name\(schd\)\)\)\)\)\)\) )) |>
tuple(constraintlabel(R69 - No updates allowed to history records of employee data.)errorcode(115169)sp_expression( semijoin\(inserts\(hist\),transform\(deletes\(hist\),\(nr_emp,dt_until\)\)\) )) |>
) |>
)
cmd( |>
assert assignmentconstraintcheck,assignmentconstraintcheck( |>
tuple(relvarname(emp)errorcode(115166)operationtype(2)) |>
tuple(relvarname(offr)errorcode(115167)operationtype(2)) |>
tuple(relvarname(offr)errorcode(115168)operationtype(2)) |>
tuple(relvarname(hist)errorcode(115169)operationtype(2)) |>
) |>
)
commit
assert constraintmessagetext,constraintmessagetext( |>
tuple(errorcode(115001)constraintmessagetext(Employee NR_EMP could not have been hired at an age under 18.  Birth date DT_BORN, hire date DT_HIRED.)) |>
tuple(errorcode(115002)constraintmessagetext(Employee NR_EMP is the president, but his salary AM_SAL_MTHLY is less than the minimum for that job \(10001\).)) |>
tuple(errorcode(115003)constraintmessagetext(Employee NR_EMP is an administrator earning AM_SAL_MTHLY, which is more than the maximum for that job \(4999\).)) |>
tuple(errorcode(115014)constraintmessagetext(Upper limit AM_UPPER_LIMIT must be at least 500 more than lower limit AM_LOWER_LIMIT in salary grade NR_SGRD.)) |>
tuple(errorcode(115015)constraintmessagetext(Lower limit AM_LOWER_LIMIT must be higher than the bonus AM_BONUS in salary grade NR_SGRD.)) |>
tuple(errorcode(115021)constraintmessagetext(Duration QY_DAYS of course CD_CRS cannot exceed 5 because it is a 'Build' course.)) |>
tuple(errorcode(115106)constraintmessagetext(Department NR_DEPT employs a manager but no administrator.)) |>
tuple(errorcode(115113)constraintmessagetext(Employee NR_EMP_MGR is the manager of QY_DEPT_MANGD departments.  Maximum allowed is 2.)) |>
tuple(errorcode(115120)constraintmessagetext(Grade limits [AM_LOWER_LIMIT-AM_UPPER_LIMIT] of grade NR_SGRD cannot completely contain [OLL-OUL] of grade OGRD.)) |>
tuple(errorcode(115121)constraintmessagetext(Grade limits [OLL-OUL] and [OLL2-OUL2] cannot both overlap with [AM_LOWER_LIMIT-AM_UPPER_LIMIT] in grade NR_SGRD.)) |>
tuple(errorcode(115122)constraintmessagetext(Both the salary grades with lower limit SLL and AM_LOWER_LIMIT have no overlapping lower grade.  This is allowed only for the lowest salary grade.)) |>
tuple(errorcode(115123)constraintmessagetext(Course offering CD_CRS on DT_START has status CD_STAT, but no assigned trainer.)) |>
tuple(errorcode(115129)constraintmessagetext(No change has occurred in either salary or department for employee NR_EMP between DT_UNTIL and DT_UNTIL2.)) |>
tuple(errorcode(115130)constraintmessagetext(Employee NR_EMP is assigned to department NR_DEPT, which is not a known department.)) |>
tuple(errorcode(115131)constraintmessagetext(Employee NR_EMP_MGR is assigned as manager of department NM_DEPT with number NR_DEPT, but is either not a known employee or else an administrator.)) |>
tuple(errorcode(115132)constraintmessagetext(Employee NR_EMP reports to employee NR_EMP_MGR, who is neither a manager nor the president.)) |>
tuple(errorcode(115133)constraintmessagetext(Employee NR_EMP has left, but has never been an employee.)) |>
tuple(errorcode(115134)constraintmessagetext(Salary grade NR_SGRD of employee NR_EMP is not a known salary grade.)) |>
tuple(errorcode(115135)constraintmessagetext(Course CD_CRS is offered on DT_START, but is not a known course.)) |>
tuple(errorcode(115136)constraintmessagetext(Course CD_CRS is offered in NM_LOC at DT_START, but no department is located there.)) |>
tuple(errorcode(115137)constraintmessagetext(Employee NR_EMP_TRNR is assigned as trainer in the DT_START offering of course CD_CRS, but no such employee is known, or that employee is not a trainer.)) |>
tuple(errorcode(115138)constraintmessagetext(Employee NR_EMP_STDNT has registered for the DT_START offering of course CD_CRS, but no such employee is known.)) |>
tuple(errorcode(115139)constraintmessagetext(Employee NR_EMP_STDNT has registered for the DT_START offering of course CD_CRS, but no such course offering exists.)) |>
tuple(errorcode(115140)constraintmessagetext(A history entry for employee NR_EMP is invalid because no such employee exists.)) |>
tuple(errorcode(115141)constraintmessagetext(The history record for employee NR_EMP for the period ending at DT_UNTIL is invalid because its department number NR_DEPT is not a known department.)) |>
tuple(errorcode(115142)constraintmessagetext(Either employee NR_EMP is a sales representative without a sales target, or else a salestarget has been registered for this employee, but this employee is not a sales representative.)) |>
tuple(errorcode(115144)constraintmessagetext(The salary AM_SAL_MTHLY of employee NR_EMP is not in the range [AM_LOWER_LIMIT-AM_UPPER_LIMIT] of the assigned salary grade NR_SGRD.)) |>
tuple(errorcode(115145)constraintmessagetext(Employee NR_EMP has left on DT_LEFT, which is either on or before the date he was hired \(DT_HIRED\).)) |>
tuple(errorcode(115146)constraintmessagetext(Sales representative NR_EMP earns more than his manager NR_EMP_MGR.)) |>
tuple(errorcode(115147)constraintmessagetext(Employee NR_EMP earns more than his manager NR_EMP_MGR.)) |>
tuple(errorcode(115148)constraintmessagetext(The change date DT_UNTIL of a history entry for employee NR_EMP is at or before the date when he/she was hired \(DT_HIRED\).)) |>
tuple(errorcode(115149)constraintmessagetext(The change date DT_UNTIL of a history entry for employee NR_EMP is after the date when he/she left \(DT_LEFT\).)) |>
tuple(errorcode(115150)constraintmessagetext(Employee NR_EMP_STDNT has registered for the DT_START offering of course CD_CRS, which is within the first four weeks after his/her hire date \(DT_HIRED\).)) |>
tuple(errorcode(115151)constraintmessagetext(Employee NR_EMP_STDNT has registered for the DT_START offering of course CD_CRS, which lasts until after his/her leave date \(DT_LEFT\).)) |>
tuple(errorcode(115152)constraintmessagetext(Employee NR_EMP_STDNT has registered for the DT_START offering of course CD_CRS as well as for the DT_START2 offering of course CD_CRS2, which overlap during PE_CRS.)) |>
tuple(errorcode(115153)constraintmessagetext(Employee NR_EMP, NM_EMP, is assigned as trainer for the DT_START offering of course CD_CRS, which is before the date he/she was hired \(DT_HIRED\).)) |>
tuple(errorcode(115154)constraintmessagetext(Employee NR_EMP_TRNR is assigned as trainer for the DT_START offering of course CD_CRS, which lasts until his/her leave date \(DT_LEFT\).)) |>
tuple(errorcode(115155)constraintmessagetext(Employee NR_EMP_TRNR has registered for the DT_START offering of course CD_CRS, for which he/she also is the assigned trainer.)) |>
tuple(errorcode(115156)constraintmessagetext(Employee NR_EMP_TRNR is the assigned trainer for the DT_START offering of course CD_CRS as well as for the DT_START2 offering of course CD_CRS2, which overlap during PE_CRS.)) |>
tuple(errorcode(115157)constraintmessagetext(Employee NR_EMP_TRNR is the assigned trainer for the DT_START offering of course CD_CRS, which overlaps with the DT_START_REG offering of course CD_CRS_REG \(for which he/she has registered as a student\) during PE_CRS.)) |>
tuple(errorcode(115158)constraintmessagetext(Employee NR_EMP_MGR does not work for any of the departments he manages \(a.o. department NR_DEPT\).)) |>
tuple(errorcode(115161)constraintmessagetext(Trainer NR_EMP_TRNR is trainer in courses off home base for more than half the time.  Total time TOTDURALL days, time at home base TOTDURLOC days.)) |>
tuple(errorcode(115163)constraintmessagetext(The DT_START offering of course CD_CRS has QY_PRTCP registered participants, exceeding the allowed maximum of QY_PRTCP_MAX.)) |>
tuple(errorcode(115165)constraintmessagetext(The DT_FIRST offering of course CD_CRS is assigned to trainer NR_EMP_TRNR, but this trainer has not worked for the company for over a year, and the course offering is not being attended by a trainer he/she has previously gotten the same course from.)) |>
tuple(errorcode(115173)constraintmessagetext(Employee NR_EMP has job NM_JOB, but that job is not defined.)) |>
tuple(errorcode(115174)constraintmessagetext(An evaluation was entered by student NR_EMP_STDNT for course offering CD_CRS on date DT_START, but no such registration exists.)) |>
tuple(errorcode(115175)constraintmessagetext(Employee NR_EMP is an employee as well as the president himself.)) |>
tuple(errorcode(115081)constraintmessagetext(The salary AM_SAL_MTHLY of employee NR_EMP is less than 1.)) |>
tuple(errorcode(115082)constraintmessagetext(The sales target AM_SLS_TRGT of salesrep NR_EMP is required to be in the range [10000-99999].)) |>
tuple(errorcode(115083)constraintmessagetext(The commission amount AM_COMM of salesrep NR_EMP is less than 1.)) |>
tuple(errorcode(115084)constraintmessagetext(Employee NR_EMP cannot be his own manager.)) |>
tuple(errorcode(115085)constraintmessagetext(Grade NR_SGRD is required to be in the range [1-99].)) |>
tuple(errorcode(115086)constraintmessagetext(Bonus AM_BONUS cannot be negative.)) |>
tuple(errorcode(115087)constraintmessagetext(Category NM_CATEG of course CD_CRS is not a valid category.  Only valid values are {'DSG' 'GEN' 'BLD'}.)) |>
tuple(errorcode(115088)constraintmessagetext(Duration QY_DAYS of course CD_CRS is not within the valid range [1-15].)) |>
tuple(errorcode(115089)constraintmessagetext(Status CD_STAT of course offering CD_CRS on DT_START is not a valid status.  Only valid values are {'SCHD' 'CONF' 'CANC'}.)) |>
tuple(errorcode(115090)constraintmessagetext(Maximum number of participants QY_PRTCP_MAX of course offering CD_CRS on DT_START is not within its valid range [6-99].)) |>
tuple(errorcode(115091)constraintmessagetext(Evaluation score CD_EVAL by student NR_EMP_STDNT of course offering CD_CRS on DT_START is not within its valid range [1-5].)) |>
tuple(errorcode(115166)constraintmessagetext(Monthly salary cannot decrease \(from AM_OSAL_MTHLY to AM_SAL_MTHLY for employee NR_EMP\).)) |>
tuple(errorcode(115167)constraintmessagetext(New offering of course CD_CRS on date DT_START has status 'CD_STAT' instead of 'SCHD'.)) |>
tuple(errorcode(115168)constraintmessagetext(Status change of course CD_CRS on DT_START from CD_STAT_OLD to CD_STAT is not permitted.)) |>
tuple(errorcode(115169)constraintmessagetext(No updates allowed to history records of employee data \(historical data of employee NR_EMP for date DT_UNTIL\).)) |>
)
