* Charset=windows-1252
* test cases for commit/rollback

starttransaction ddb
* define the attributes used and their types
cmd( |>
assert attribute,attribute( |>
tuple(attributename(I)typename(INT)) |>
tuple(attributename(S)typename(STRING)) |>
) |>
) |>
cmd( |>
assert attributelogicallength,attributelogicallength( |>
tuple(attributename(S)logicallength(262144)) |>
) |>
)

* define the relvar
cmd( |>
assert relvar,relvar( |>
tuple(relvarname(CMRB)relvarpredicate(I for S.)) |>
) |>
) |>
cmd( |>
assert relvarattribute,relvarattribute( |>
tuple(relvarname(CMRB)attributename(I)) |>
tuple(relvarname(CMRB)attributename(S)) |>
) |>
)

* define the storage resources
cmd( |>
assert dbmsfile,dbmsfile( |>
tuple(filename(CMRB.SPDB)pagesize(8192)) |>
) |>
) |>
cmd( |>
assert storagespace,storagespace( |>
tuple(filename(CMRB.SPDB)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(CMRB.SPDB)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
assert dataspace,dataspace( |>
tuple(filename(CMRB.SPDB)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert multihashingindexspace,multihashingindexspace( |>
tuple(filename(CMRB.SPDB)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

* define the physical design
cmd( |>
assert recordtype,recordtype( |>
tuple(filename(CMRB.SPDB)storagespaceid(1)recordtypename(R_CMRB)indexname(L_R_CMRB)relvarname(CMRB)) |>
) |>
) |>
cmd( |>
assert index,index( |>
tuple(filename(CMRB.SPDB)storagespaceid(2)recordtypename(R_CMRB)relvarname(CMRB)indexname(L_R_CMRB)) |>
) |>
) |>
cmd( |>
assert recordattribute,recordattribute( |>
tuple(recordtypename(R_CMRB)relvarname(CMRB)attributename(I)ordinal(10)) |>
) |>
) |>
cmd( |>
assert indexcomponent,indexcomponent( |>
tuple(relvarname(CMRB)indexname(L_R_CMRB)ordinal(10)sp_expression(I)) |>
) |>
)
endtransaction ddb


starttransaction clear
delete cmrb,cmrb
endtransaction clear

starttransaction A1
add cmrb,cmrb(tuple(i(1)s(you))tuple(i(2)s(me)))
commit A1
add cmrb,cmrb(tuple(i(7)s(who)))
inquire cmrb
startnestedtransaction B1
inquire cmrb
add cmrb,cmrb(tuple(i(3)s(him)))
inquire cmrb
rollback B1
inquire cmrb
add cmrb,cmrb(tuple(i(3)s(him)))
inquire cmrb
commit B1
inquire cmrb
add cmrb,cmrb(tuple(i(4)s(us)))
inquire cmrb
rollback B1
inquire cmrb

rollback A1
inquire cmrb
add cmrb,cmrb(tuple(i(3)s(him)))
endtransaction A1

starttransaction clear
inquire cmrb
delete cmrb,cmrb
endtransaction clear

starttransaction cldb
* remove the physical design
cmd( |>
unassert recordtype,recordtype( |>
tuple(filename(CMRB.SPDB)storagespaceid(1)recordtypename(R_CMRB)indexname(L_R_CMRB)relvarname(CMRB)) |>
) |>
) |>
cmd( |>
unassert index,index( |>
tuple(filename(CMRB.SPDB)storagespaceid(2)recordtypename(R_CMRB)relvarname(CMRB)indexname(L_R_CMRB)) |>
) |>
) |>
cmd( |>
unassert recordattribute,recordattribute( |>
tuple(recordtypename(R_CMRB)relvarname(CMRB)attributename(I)ordinal(10)) |>
) |>
) |>
cmd( |>
unassert indexcomponent,indexcomponent( |>
tuple(relvarname(CMRB)indexname(L_R_CMRB)ordinal(10)sp_expression(I)) |>
) |>
)

* remove the storage resources
cmd( |>
unassert dbmsfile,dbmsfile( |>
tuple(filename(CMRB.SPDB)pagesize(8192)) |>
) |>
) |>
cmd( |>
unassert storagespace,storagespace( |>
tuple(filename(CMRB.SPDB)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(CMRB.SPDB)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
unassert dataspace,dataspace( |>
tuple(filename(CMRB.SPDB)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert multihashingindexspace,multihashingindexspace( |>
tuple(filename(CMRB.SPDB)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

* remove the logical design
cmd( |>
unassert relvar,relvar( |>
tuple(relvarname(CMRB)relvarpredicate(I for S.)) |>
) |>
) |>
cmd( |>
unassert relvarattribute,relvarattribute( |>
tuple(relvarname(CMRB)attributename(I)) |>
tuple(relvarname(CMRB)attributename(S)) |>
) |>
)

* remove the attributes used
cmd( |>
unassert attribute,semiminus(attribute( |>
tuple(attributename(I)typename(INT)) |>
tuple(attributename(S)typename(STRING)) |>
),relvarattribute) |>
) |>
cmd( |>
unassert attributelogicallength,semiminus(attributelogicallength( |>
tuple(attributename(S)logicallength(262144)) |>
),relvarattribute) |>
)
endtransaction cldb
