* Charset=windows-1252
* test cases for using virtual relvars in database constraints

* attributes and relvar design
cmd( |>
assert attribute,attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
tuple(attributename(scalar3)typename(long)) |>
) |>
) |>
cmd( |>
assert relvar,relvar( |>
tuple(relvarname(dbcvrv1)relvarpredicate(record with scalar1 and scalar2 and scalar3.)) |>
) |>
) |>
cmd( |>
assert relvarattribute,relvarattribute( |>
tuple(relvarname(dbcvrv1)attributename(scalar1)) |>
tuple(relvarname(dbcvrv1)attributename(scalar2)) |>
tuple(relvarname(dbcvrv1)attributename(scalar3)) |>
) |>
)

* persistence resources
cmd( |>
assert storagespace,storagespace( |>
tuple(filename(dbcvrv1a.spdb)extentscount(2)pagecount(2)storagespaceid(1)) |>
tuple(filename(dbcvrv1a.spdb)extentscount(2)pagecount(2)storagespaceid(2)) |>
) |>
) |>
cmd( |>
assert dataspace,dataspace( |>
tuple(filename(dbcvrv1a.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert dbmsfile,dbmsfile( |>
tuple(filename(dbcvrv1a.spdb)pagesize(8192))) |>
) |>
) |>
cmd( |>
assert hashingindexspace,hashingindexspace( |>
tuple(filename(dbcvrv1a.spdb)storagespaceid(2)) |>
) |>
)

* physical relvar design
cmd( |>
assert recordtype,recordtype( |>
tuple(filename(dbcvrv1a.spdb)storagespaceid(1)indexname(l_r_dbcvrv1)recordtypename(r_dbcvrv1)relvarname(dbcvrv1)) |>
) |>
) |>
cmd( |>
assert index,index( |>
tuple(filename(dbcvrv1a.spdb)storagespaceid(2)recordtypename(r_dbcvrv1)relvarname(dbcvrv1)indexname(l_r_dbcvrv1)) |>
) |>
) |>
cmd( |>
assert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbcvrv1)relvarname(dbcvrv1)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_dbcvrv1)relvarname(dbcvrv1)attributename(scalar2)ordinal(20)) |>
tuple(recordtypename(r_dbcvrv1)relvarname(dbcvrv1)attributename(scalar3)ordinal(30)) |>
) |>
) |>
cmd( |>
assert indexcomponent,indexcomponent( |>
tuple(relvarname(dbcvrv1)indexname(l_r_dbcvrv1)ordinal(10)sp_expression(scalar1)) |>
) |>
)

* test cases for using virtual relvars in database constraints

* clear the relvar 
delete dbcvrv1,dbcvrv1
commit

* viewexpression : update if it exists, assert if it doesn't
update virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_dbcvrv1))),(sp_expression(string(relation\(heading\(\)body\(\)\))))
assert virtualrelvar,virtualrelvar(tuple(relvarname(v_dbcvrv1)sp_expression(string(relation\(heading\(\)body\(\)\)))))

* set a database constraint involving v_vrtdbc
assert databaseconstraint,databaseconstraint( |>
tuple(errorcode(184005)constraintlabel(test with view) sp_expression(join\(restrict\(dbcvrv1,gt\(scalar1,scalar2\)\),v_dbcvrv1\) )) |>
)

* populate the relvar - should pass because the view evaluates to table_dum
assert dbcvrv1,dbcvrv1(tuple(scalar1(1)scalar2(0)scalar3(0)))
commit

* change view expression - should cause detection of dbcvrv1 in violation of constraint
update virtualrelvar,virtualrelvar(tuple(relvarname(v_dbcvrv1)sp_expression(string(relation\(heading\(\)body\(\)\))))),(sp_expression(string(relation\(heading\(\)body\(tuple\(\)\)\))))

* change the data
update dbcvrv1,,(scalar2(long(2)))
commit

* change view expression - should now succeed because data has changed
update virtualrelvar,virtualrelvar(tuple(relvarname(v_dbcvrv1)sp_expression(string(relation\(heading\(\)body\(\)\))))),(sp_expression(string(relation\(heading\(\)body\(tuple\(\)\)\))))

* populate the relvar - should fail because of the new database constraint
assert dbcvrv1,dbcvrv1(tuple(scalar1(1)scalar2(0)scalar3(0)))
commit

* clean up the database constraint
delete databaseconstraint,restrict(databaseconstraint,eq(errorcode,long(184005)))

* clean up the view
delete virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_dbcvrv1)))

* clear the relvar 
delete dbcvrv1,dbcvrv1

* clean up test cases for using virtual relvars in database constraints

* the relvar data
delete dbcvrv1,dbcvrv1
commit

* physical relvar design
cmd( |>
unassert recordtype,recordtype( |>
tuple(filename(dbcvrv1a.spdb)storagespaceid(1)indexname(l_r_dbcvrv1)recordtypename(r_dbcvrv1)relvarname(dbcvrv1)) |>
) |>
) |>
cmd( |>
unassert index,index( |>
tuple(filename(dbcvrv1a.spdb)storagespaceid(2)recordtypename(r_dbcvrv1)relvarname(dbcvrv1)indexname(l_r_dbcvrv1)) |>
) |>
) |>
cmd( |>
unassert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbcvrv1)relvarname(dbcvrv1)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_dbcvrv1)relvarname(dbcvrv1)attributename(scalar2)ordinal(20)) |>
tuple(recordtypename(r_dbcvrv1)relvarname(dbcvrv1)attributename(scalar3)ordinal(30)) |>
) |>
) |>
cmd( |>
unassert indexcomponent,indexcomponent( |>
tuple(relvarname(dbcvrv1)indexname(l_r_dbcvrv1)ordinal(10)sp_expression(scalar1)) |>
) |>
)

* persistence resources
cmd( |>
unassert storagespace,storagespace( |>
tuple(filename(dbcvrv1a.spdb)extentscount(2)pagecount(2)storagespaceid(1)) |>
tuple(filename(dbcvrv1a.spdb)extentscount(2)pagecount(2)storagespaceid(2)) |>
) |>
) |>
cmd( |>
unassert dataspace,dataspace( |>
tuple(filename(dbcvrv1a.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert dbmsfile,dbmsfile( |>
tuple(filename(dbcvrv1a.spdb)pagesize(8192))) |>
) |>
) |>
cmd( |>
unassert hashingindexspace,hashingindexspace( |>
tuple(filename(dbcvrv1a.spdb)storagespaceid(2)) |>
) |>
)

* attributes and relvar design
cmd( |>
unassert attribute,semiminus(attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
tuple(attributename(scalar3)typename(long)) |>
),relvarattribute) |>
) |>
cmd( |>
unassert relvar,relvar( |>
tuple(relvarname(dbcvrv1)relvarpredicate(record with scalar1 and scalar2 and scalar3.)) |>
) |>
) |>
cmd( |>
unassert relvarattribute,relvarattribute( |>
tuple(relvarname(dbcvrv1)attributename(scalar1)) |>
tuple(relvarname(dbcvrv1)attributename(scalar2)) |>
tuple(relvarname(dbcvrv1)attributename(scalar3)) |>
) |>
)

* viewexpression
unassert virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_dbcvrv1)))
