* Charset=windows-1252
* test-cases for non-user-related assignment constraints

* define the attributes used in the test
assert attribute,attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
)

* define the logical design of the relvars used in the test
cmd( |>
assert relvar,relvar( |>
tuple(relvarname(dbm_assc)relvarpredicate(scalar1 and scalar2.)) |>
) |>
) |>
cmd( |>
assert relvarattribute,relvarattribute( |>
tuple(relvarname(dbm_assc)attributename(scalar1)) |>
tuple(relvarname(dbm_assc)attributename(scalar2)) |>
) |>
)

* define the storage resources used in the test
cmd( |>
assert dbmsfile,dbmsfile( |>
tuple(filename(dbm_assc.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
assert storagespace,storagespace( |>
tuple(filename(dbm_assc.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(dbm_assc.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
assert dataspace,dataspace( |>
tuple(filename(dbm_assc.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert multihashingindexspace,multihashingindexspace( |>
tuple(filename(dbm_assc.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

* define the physical design of the relvars used in the test
cmd( |>
assert recordtype,recordtype( |>
tuple(indexname(l_r_dbm_assc)filename(dbm_assc.spdb)storagespaceid(1)recordtypename(r_dbm_assc)relvarname(dbm_assc)) |>
) |>
) |>
cmd( |>
assert index,index( |>
tuple(filename(dbm_assc.spdb)storagespaceid(2)recordtypename(r_dbm_assc)relvarname(dbm_assc)indexname(l_r_dbm_assc)) |>
) |>
) |>
cmd( |>
assert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbm_assc)relvarname(dbm_assc)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_dbm_assc)relvarname(dbm_assc)attributename(scalar2)ordinal(20)) |>
) |>
) |>
cmd( |>
assert indexcomponent,indexcomponent( |>
tuple(relvarname(dbm_assc)indexname(l_r_dbm_assc)ordinal(10)sp_expression(scalar1)) |>
tuple(relvarname(dbm_assc)indexname(l_r_dbm_assc)ordinal(20)sp_expression(scalar2)) |>
) |>
)


delete dbm_assc,dbm_assc
commit

* add an insert-transaction constraint
assert assignmentconstraint,assignmentconstraint( |>
tuple(constraintlabel(nothing goes in)errorcode(181001)sp_expression(inserts\(dbm_assc\))) |>
)
commit

inquire restrict(constraintinvolvesrelvar,eq(errorcode,long(181001)))

* must succeed, because there is no constraintcheck linking to this constraint
assert dbm_assc,dbm_assc( |>
tuple(scalar1(1)scalar2(2)) |>
)
inquire dbm_assc
commit

* add the constraint check too
assert assignmentconstraintcheck,assignmentconstraintcheck( |>
tuple(relvarname(dbm_assc)operationtype(2)errorcode(181001)) |>
)
commit

* must succeed, because there is no true addition done
assert dbm_assc,dbm_assc( |>
tuple(scalar1(1)scalar2(2)) |>
)
inquire dbm_assc
commit

* must fail, because now there is a true addition done
assert dbm_assc,dbm_assc( |>
tuple(scalar1(1)scalar2(3)) |>
)
inquire dbm_assc
commit

* must fail on RI
unassert assignmentconstraint,assignmentconstraint( |>
tuple(constraintlabel(nothing goes in)errorcode(181001)sp_expression(inserts\(dbm_assc\))) |>
)
commit

inquire restrict(constraintinvolvesrelvar,eq(errorcode,long(181001)))

* must succeed
cmd( |>
unassert assignmentconstraint,assignmentconstraint( |>
tuple(constraintlabel(nothing goes in)errorcode(181001)sp_expression(inserts\(dbm_assc\))) |>
) |>
) |>
cmd( |>
unassert assignmentconstraintcheck,assignmentconstraintcheck( |>
tuple(relvarname(dbm_assc)operationtype(2)errorcode(181001)) |>
) |>
)
commit

inquire restrict(constraintinvolvesrelvar,eq(errorcode,long(181001)))

* must succeed, because now there is no more constraint
assert dbm_assc,dbm_assc( |>
tuple(scalar1(1)scalar2(3)) |>
)
inquire dbm_assc
commit

* upon insertion, scalar1 must be <= scalar2
cmd( |>
assert assignmentconstraint,assignmentconstraint( |>
tuple(constraintlabel(s1 <= s2)errorcode(181001)sp_expression(restrict\(inserts\(dbm_assc\),gt\(scalar1,scalar2\)\))) |>
) |>
) |>
cmd( |>
assert assignmentconstraintcheck,assignmentconstraintcheck( |>
tuple(relvarname(dbm_assc)operationtype(2)errorcode(181001)) |>
) |>
)
commit

inquire restrict(constraintinvolvesrelvar,eq(errorcode,long(181001)))

* must pass
assert dbm_assc,dbm_assc( |>
tuple(scalar1(2)scalar2(2)) |>
)
* must fail
assert dbm_assc,dbm_assc( |>
tuple(scalar1(3)scalar2(2)) |>
)
commit

* test updates - must both fail too
update dbm_assc,,(scalar1(plus(scalar1,long(5))))
update dbm_assc,,(scalar2(plus(scalar2,long(-5))))
commit

* scalar1 may not be known as a relvarid
update assignmentconstraint,restrict(assignmentconstraint,eq(errorcode,long(181001))), |>
                            (sp_expression(join\(rename\(inserts\(dbm_assc\),\(scalar1,relvarid\)\),relvarid\)))
commit

inquire restrict(constraintinvolvesrelvar,eq(errorcode,long(181001)))

* test it - must fail
assert dbm_assc,dbm_assc( |>
tuple(scalar1(2)scalar2(9)) |>
)
* test it - must pass
assert dbm_assc,dbm_assc( |>
tuple(scalar1(2468013579)scalar2(9876543210)) |>
)
commit

cmd( |>
delete assignmentconstraint,restrict(assignmentconstraint,eq(errorcode,long(181001))) |>
) |>
cmd( |>
delete assignmentconstraintcheck,restrict(assignmentconstraintcheck,eq(errorcode,long(181001))) |>
)
commit

delete dbm_assc,dbm_assc
commit

* remove the physical design of the relvars used in the test
cmd( |>
unassert recordtype,recordtype( |>
tuple(indexname(l_r_dbm_assc)filename(dbm_assc.spdb)storagespaceid(1)recordtypename(r_dbm_assc)relvarname(dbm_assc)) |>
) |>
) |>
cmd( |>
unassert index,index( |>
tuple(filename(dbm_assc.spdb)storagespaceid(2)recordtypename(r_dbm_assc)relvarname(dbm_assc)indexname(l_r_dbm_assc)) |>
) |>
) |>
cmd( |>
unassert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbm_assc)relvarname(dbm_assc)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_dbm_assc)relvarname(dbm_assc)attributename(scalar2)ordinal(20)) |>
) |>
) |>
cmd( |>
unassert indexcomponent,indexcomponent( |>
tuple(relvarname(dbm_assc)indexname(l_r_dbm_assc)ordinal(10)sp_expression(scalar1)) |>
tuple(relvarname(dbm_assc)indexname(l_r_dbm_assc)ordinal(20)sp_expression(scalar2)) |>
) |>
)

* remove the storage resources used in the test
cmd( |>
unassert dbmsfile,dbmsfile( |>
tuple(filename(dbm_assc.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
unassert storagespace,storagespace( |>
tuple(filename(dbm_assc.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(dbm_assc.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
unassert dataspace,dataspace( |>
tuple(filename(dbm_assc.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert multihashingindexspace,multihashingindexspace( |>
tuple(filename(dbm_assc.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

* remove the logical design of the relvars used in the test
cmd( |>
unassert relvar,relvar( |>
tuple(relvarname(dbm_assc)relvarpredicate(scalar1 and scalar2.)) |>
) |>
) |>
cmd( |>
unassert relvarattribute,relvarattribute( |>
tuple(relvarname(dbm_assc)attributename(scalar1)) |>
tuple(relvarname(dbm_assc)attributename(scalar2)) |>
) |>
)

* remove the attributes used in the test
unassert attribute,semiminus(attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
),relvarattribute)

