* Charset=windows-1252
* test-cases for currentdate-related assignment constraints

* define the attributes used in the test
assert attribute,attribute( |>
tuple(attributename(trdate)typename(date)) |>
)

* define the logical design of the relvars used in the test
cmd( |>
assert relvar,relvar( |>
tuple(relvarname(dbm_asscd)relvarpredicate(entered on trdate.)) |>
) |>
) |>
cmd( |>
assert relvarattribute,relvarattribute( |>
tuple(relvarname(dbm_asscd)attributename(trdate)) |>
) |>
)

* define the storage resources used in the test
cmd( |>
assert dbmsfile,dbmsfile( |>
tuple(filename(dbm_asscd.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
assert storagespace,storagespace( |>
tuple(filename(dbm_asscd.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(dbm_asscd.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
assert dataspace,dataspace( |>
tuple(filename(dbm_asscd.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert multihashingindexspace,multihashingindexspace( |>
tuple(filename(dbm_asscd.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

* define the physical design of the relvars used in the test
cmd( |>
assert recordtype,recordtype( |>
tuple(indexname(l_r_dbm_asscd)filename(dbm_asscd.spdb)storagespaceid(1)recordtypename(r_dbm_asscd)relvarname(dbm_asscd)) |>
) |>
) |>
cmd( |>
assert index,index( |>
tuple(filename(dbm_asscd.spdb)storagespaceid(2)recordtypename(r_dbm_asscd)relvarname(dbm_asscd)indexname(l_r_dbm_asscd)) |>
) |>
) |>
cmd( |>
assert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbm_asscd)relvarname(dbm_asscd)attributename(trdate)ordinal(10)) |>
) |>
) |>
cmd( |>
assert indexcomponent,indexcomponent( |>
tuple(relvarname(dbm_asscd)indexname(l_r_dbm_asscd)ordinal(10)sp_expression(trdate)) |>
) |>
)

delete dbm_asscd,dbm_asscd
commit

* add an insert-assignment constraint
cmd( |>
assert assignmentconstraint,assignmentconstraint( |>
tuple(constraintlabel(not future-dated)errorcode(181001)sp_expression(restrict\(join\(currentdate,inserts\(dbm_asscd\)\),gt\(trdate,currentdate\)\))) |>
) |>
) |>
cmd( |>
assert assignmentconstraintcheck,assignmentconstraintcheck( |>
tuple(relvarname(dbm_asscd)operationtype(2)errorcode(181001)) |>
) |>
)
commit

* must fail
assert dbm_asscd,transform(currentdate,trdate(dateshift(currentdate,int(1),int(0),int(0))))
inquire dbm_asscd

* must fail
assert dbm_asscd,transform(currentdate,trdate(dateshift(currentdate,int(0),int(1),int(0))))
inquire dbm_asscd

* must fail
assert dbm_asscd,transform(currentdate,trdate(dateshift(currentdate,int(0),int(0),int(1))))
inquire dbm_asscd

* must fail
assert dbm_asscd,union(dbm_asscd( |>
tuple(trdate(2007-09-05)) |>
),transform(currentdate,trdate(dateshift(currentdate,int(0),int(0),int(1)))))
inquire dbm_asscd

* must pass
assert dbm_asscd,dbm_asscd( |>
tuple(trdate(2007-09-05)) |>
)
inquire dbm_asscd

* must pass
assert dbm_asscd,transform(currentdate,trdate(currentdate))
inquire dbm_asscd

* must pass
assert dbm_asscd,union(dbm_asscd( |>
),transform(currentdate,trdate(dateshift(currentdate,int(0),int(0),int(-1)))))
inquire dbm_asscd

commit

* remove for purposes of clean-up and rerunnability
cmd( |>
unassert assignmentconstraint,assignmentconstraint( |>
tuple(constraintlabel(not future-dated)errorcode(181001)sp_expression(restrict\(join\(currentdate,inserts\(dbm_asscd\)\),gt\(trdate,currentdate\)\))) |>
) |>
) |>
cmd( |>
unassert assignmentconstraintcheck,assignmentconstraintcheck( |>
tuple(relvarname(dbm_asscd)operationtype(2)errorcode(181001)) |>
) |>
)
commit

delete dbm_asscd,dbm_asscd
commit

* remove the physical design of the relvars used in the test
cmd( |>
unassert recordtype,recordtype( |>
tuple(indexname(l_r_dbm_asscd)filename(dbm_asscd.spdb)storagespaceid(1)recordtypename(r_dbm_asscd)relvarname(dbm_asscd)) |>
) |>
) |>
cmd( |>
unassert index,index( |>
tuple(filename(dbm_asscd.spdb)storagespaceid(2)recordtypename(r_dbm_asscd)relvarname(dbm_asscd)indexname(l_r_dbm_asscd)) |>
) |>
) |>
cmd( |>
unassert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbm_asscd)relvarname(dbm_asscd)attributename(trdate)ordinal(10)) |>
) |>
) |>
cmd( |>
unassert indexcomponent,indexcomponent( |>
tuple(relvarname(dbm_asscd)indexname(l_r_dbm_asscd)ordinal(10)sp_expression(trdate)) |>
) |>
)

* remove the storage resources used in the test
cmd( |>
unassert dbmsfile,dbmsfile( |>
tuple(filename(dbm_asscd.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
unassert storagespace,storagespace( |>
tuple(filename(dbm_asscd.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(dbm_asscd.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
unassert dataspace,dataspace( |>
tuple(filename(dbm_asscd.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert multihashingindexspace,multihashingindexspace( |>
tuple(filename(dbm_asscd.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

* remove the logical design of the relvars used in the test
cmd( |>
unassert relvar,relvar( |>
tuple(relvarname(dbm_asscd)relvarpredicate(entered on trdate.)) |>
) |>
) |>
cmd( |>
unassert relvarattribute,relvarattribute( |>
tuple(relvarname(dbm_asscd)attributename(trdate)) |>
) |>
)

* remove the attributes used in the test
unassert attribute,semiminus(attribute( |>
tuple(attributename(trdate)typename(date)) |>
),relvarattribute)

