* Charset=windows-1252
* test cases for using virtual relvars in assignment constraints

* attributes and relvar design
cmd( |>
assert attribute,attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
tuple(attributename(scalar3)typename(long)) |>
) |>
) |>
cmd( |>
assert relvar,relvar( |>
tuple(relvarname(vrtasc1)relvarpredicate(record with scalar1 and scalar2 and scalar3.)) |>
) |>
) |>
cmd( |>
assert relvarattribute,relvarattribute( |>
tuple(relvarname(vrtasc1)attributename(scalar1)) |>
tuple(relvarname(vrtasc1)attributename(scalar2)) |>
tuple(relvarname(vrtasc1)attributename(scalar3)) |>
) |>
)

* persistence resources
cmd( |>
assert storagespace,storagespace( |>
tuple(filename(vrtasc1a.spdb)extentscount(2)pagecount(2)storagespaceid(1)) |>
tuple(filename(vrtasc1a.spdb)extentscount(2)pagecount(2)storagespaceid(2)) |>
) |>
) |>
cmd( |>
assert dataspace,dataspace( |>
tuple(filename(vrtasc1a.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert dbmsfile,dbmsfile( |>
tuple(filename(vrtasc1a.spdb)pagesize(8192))) |>
) |>
) |>
cmd( |>
assert hashingindexspace,hashingindexspace( |>
tuple(filename(vrtasc1a.spdb)storagespaceid(2)) |>
) |>
)

* physical relvar design
cmd( |>
assert recordtype,recordtype( |>
tuple(filename(vrtasc1a.spdb)storagespaceid(1)indexname(l_r_vrtasc1)recordtypename(r_vrtasc1)relvarname(vrtasc1)) |>
) |>
) |>
cmd( |>
assert index,index( |>
tuple(filename(vrtasc1a.spdb)storagespaceid(2)recordtypename(r_vrtasc1)relvarname(vrtasc1)indexname(l_r_vrtasc1)) |>
) |>
) |>
cmd( |>
assert recordattribute,recordattribute( |>
tuple(recordtypename(r_vrtasc1)relvarname(vrtasc1)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_vrtasc1)relvarname(vrtasc1)attributename(scalar2)ordinal(20)) |>
tuple(recordtypename(r_vrtasc1)relvarname(vrtasc1)attributename(scalar3)ordinal(30)) |>
) |>
) |>
cmd( |>
assert indexcomponent,indexcomponent( |>
tuple(relvarname(vrtasc1)indexname(l_r_vrtasc1)ordinal(10)sp_expression(scalar1)) |>
) |>
)

* test cases for using virtual relvars in assignment constraints

* clear the relvar 
delete vrtasc1,vrtasc1
commit

* viewexpression : update if it exists, assert if it doesn't
update virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrtasc1))),(sp_expression(STRING(RELATION\(HEADING\(\)BODY\(\)\))))
assert virtualrelvar,virtualrelvar(tuple(relvarname(v_vrtasc1)sp_expression(STRING(RELATION\(HEADING\(\)BODY\(\)\)))))

* set a database constraint involving V_VRTASC
cmd( |>
assert assignmentconstraint,assignmentconstraint( |>
tuple(errorcode(184006)constraintlabel(test with view) sp_expression(join\(restrict\(inserts\(VRTASC1\),GT\(SCALAR1,SCALAR2\)\),v_vrtasc1\) )) |>
) |>
) |>
cmd( |>
assert assignmentconstraintcheck,assignmentconstraintcheck( |>
tuple(errorcode(184006)relvarname(vrtasc1)operationtype(2)) |>
) |>
)

* populate the relvar - should pass because the view evaluates to TABLE_DUM
assert vrtasc1,vrtasc1(tuple(scalar1(1)scalar2(0)scalar3(0)))
commit

* change view expression - should succeed because there's no check on existing data
update virtualrelvar,virtualrelvar(tuple(relvarname(v_vrtasc1)sp_expression(STRING(RELATION\(HEADING\(\)BODY\(\)\))))),(sp_expression(STRING(RELATION\(HEADING\(\)BODY\(TUPLE\(\)\)\))))

* populate the relvar - should fail because of the new assignment constraint
assert vrtasc1,vrtasc1(tuple(scalar1(2)scalar2(1)scalar3(0)))
commit

* now test mith multiple levels of nested views - assert second view (update if it exists - create if it doesn't)
update virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrtasc2))),(sp_expression(STRING(TABLE_DEE)))
assert virtualrelvar,virtualrelvar(tuple(relvarname(v_vrtasc2)sp_expression(STRING(TABLE_DEE))))

* change V1 expression to reference V2
update virtualrelvar,virtualrelvar(tuple(relvarname(v_vrtasc1)sp_expression(STRING(RELATION\(HEADING\(\)BODY\(TUPLE\(\)\)\))))),(sp_expression(STRING(v_vrtasc2)))

* populate the relvar - should fail because of the new assignment constraint is still TABLE_DEE
assert vrtasc1,vrtasc1(tuple(scalar1(2)scalar2(1)scalar3(0)))
commit

* change V2 to TABLE_DUM
update virtualrelvar,virtualrelvar(tuple(relvarname(v_vrtasc2)sp_expression(STRING(TABLE_DEE)))),(sp_expression(STRING(TABLE_DUM)))

* populate the relvar - should now succeed
assert vrtasc1,vrtasc1(tuple(scalar1(2)scalar2(1)scalar3(0)))
commit

* clean up the view - should fail because the assignment constraint still references it - this should not cause a server crash
delete virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrtasc2)))

* clean up the view - should fail because the assignment constraint still references it - this should not cause a server crash
delete virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrtasc1)))

* clean up the assignment constraint
cmd( |>
delete assignmentconstraint,restrict(assignmentconstraint,eq(errorcode,long(184006))) |>
) |>
cmd( |>
delete assignmentconstraintcheck,restrict(assignmentconstraintcheck,eq(errorcode,long(184006))) |>
)

* clean up the view
delete virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrtasc1)))
delete virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrtasc2)))

* clear the relvar 
delete vrtasc1,vrtasc1

* clean up test cases for using virtual relvars in assignment constraints

* the relvar data
delete vrtasc1,vrtasc1
commit

* physical relvar design
cmd( |>
unassert recordtype,recordtype( |>
tuple(filename(vrtasc1a.spdb)storagespaceid(1)indexname(l_r_vrtasc1)recordtypename(r_vrtasc1)relvarname(vrtasc1)) |>
) |>
) |>
cmd( |>
unassert index,index( |>
tuple(filename(vrtasc1a.spdb)storagespaceid(2)recordtypename(r_vrtasc1)relvarname(vrtasc1)indexname(l_r_vrtasc1)) |>
) |>
) |>
cmd( |>
unassert recordattribute,recordattribute( |>
tuple(recordtypename(r_vrtasc1)relvarname(vrtasc1)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_vrtasc1)relvarname(vrtasc1)attributename(scalar2)ordinal(20)) |>
tuple(recordtypename(r_vrtasc1)relvarname(vrtasc1)attributename(scalar3)ordinal(30)) |>
) |>
) |>
cmd( |>
unassert indexcomponent,indexcomponent( |>
tuple(relvarname(vrtasc1)indexname(l_r_vrtasc1)ordinal(10)sp_expression(scalar1)) |>
) |>
)

* persistence resources
cmd( |>
unassert storagespace,storagespace( |>
tuple(filename(vrtasc1a.spdb)extentscount(2)pagecount(2)storagespaceid(1)) |>
tuple(filename(vrtasc1a.spdb)extentscount(2)pagecount(2)storagespaceid(2)) |>
) |>
) |>
cmd( |>
unassert dataspace,dataspace( |>
tuple(filename(vrtasc1a.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert dbmsfile,dbmsfile( |>
tuple(filename(vrtasc1a.spdb)pagesize(8192))) |>
) |>
) |>
cmd( |>
unassert hashingindexspace,hashingindexspace( |>
tuple(filename(vrtasc1a.spdb)storagespaceid(2)) |>
) |>
)

* attributes and relvar design
cmd( |>
unassert attribute,semiminus(attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
tuple(attributename(scalar3)typename(long)) |>
),relvarattribute) |>
) |>
cmd( |>
unassert relvar,relvar( |>
tuple(relvarname(vrtasc1)relvarpredicate(record with scalar1 and scalar2 and scalar3.)) |>
) |>
) |>
cmd( |>
unassert relvarattribute,relvarattribute( |>
tuple(relvarname(vrtasc1)attributename(scalar1)) |>
tuple(relvarname(vrtasc1)attributename(scalar2)) |>
tuple(relvarname(vrtasc1)attributename(scalar3)) |>
) |>
)

* viewexpression
unassert virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrtasc1)))
