* Charset=windows-1252
* test cases for management of attributes

* define a user-implemented type, a variable-length constrained type and a fixed-length constrained type
assert constrainedtype,constrainedtype(tuple(typename(splong)sp_expression( gt\(parameter\(v\(long\)\),long\(0\) \) )basetype(long)))
assert constrainedtype,constrainedtype(tuple(typename(shtring)sp_expression( gt\(int\(4800\),length\(parameter\(v\(string\)\)\) \) )basetype(string)))

* define attrs of these types - should fail on missing logical length declaration for one of them
assert attribute,attribute( |>
tuple(attributename(dbmatt_angle)typename(angle)) |>
tuple(attributename(dbmatt_splong)typename(splong)) |>
tuple(attributename(dbmatt_shtring)typename(shtring)) |>
)

* define attrs of these types - should fail on superfluous logical length declaration for one of them
cmd( |>
assert attribute,attribute( |>
tuple(attributename(dbmatt_angle)typename(angle)) |>
tuple(attributename(dbmatt_splong)typename(splong)) |>
tuple(attributename(dbmatt_shtring)typename(shtring)) |>
) |>
) |>
cmd( |>
assert attributelogicallength,attributelogicallength( |>
tuple(attributename(dbmatt_angle)logicallength(1)) |>
tuple(attributename(dbmatt_splong)logicallength(18)) |>
tuple(attributename(dbmatt_shtring)logicallength(5000)) |>
) |>
)

* define attrs of these types - finally get it right
cmd( |>
assert attribute,attribute( |>
tuple(attributename(dbmatt_angle)typename(angle)) |>
tuple(attributename(dbmatt_splong)typename(splong)) |>
tuple(attributename(dbmatt_shtring)typename(shtring)) |>
) |>
) |>
cmd( |>
assert attributelogicallength,attributelogicallength( |>
tuple(attributename(dbmatt_shtring)logicallength(5000)) |>
) |>
)

* physical lengths should have appeared
inquire join(attributephysicallength,relation(heading(attributename(name))body(tuple(attributename(dbmatt_shtring))tuple(attributename(dbmatt_splong))tuple(attributename(dbmatt_angle)))))

* try to force physical lengths onto SIRA_PRISE, should fail
update attributephysicallength,restrict(attributephysicallength,eq(attributename,name(dbmatt_shtring))),(physicallength(5000))

* try to corrupt physical lengths, should fail
delete attributephysicallength,restrict(attributephysicallength,eq(attributename,name(dbmatt_shtring)))

* delete FL attribute without logical deleting logical length - should pass
unassert attribute,attribute( |>
tuple(attributename(dbmatt_angle)typename(angle)) |>
)

* delete VL attribute without logical deleting logical length - should fail
unassert attribute,attribute( |>
tuple(attributename(dbmatt_shtring)typename(shtring)) |>
)

* delete VL attribute including logical logical length - should succeed
cmd( |>
unassert attribute,attribute( |>
tuple(attributename(dbmatt_shtring)typename(shtring)) |>
) |>
) |>
cmd( |>
unassert attributelogicallength,attributelogicallength( |>
tuple(attributename(dbmatt_shtring)logicallength(5000)) |>
) |>
)

* physical lengths should have disappeared
inquire join(attributephysicallength,relation(heading(attributename(name))body(tuple(attributename(dbmatt_shtring))tuple(attributename(dbmatt_splong))tuple(attributename(dbmatt_angle)))))

* change attribute type to VL type without adding logical length - should fail
update attribute,attribute(tuple(attributename(dbmatt_splong)typename(splong))),(typename(shtring))

* change attribute type to VL type while adding logical length - should pass
cmd( |>
update attribute,attribute(tuple(attributename(dbmatt_splong)typename(splong))),(typename(shtring)) |>
) |>
cmd( |>
add attributelogicallength,attributelogicallength(tuple(attributename(dbmatt_splong)logicallength(2500))) |>
) 

* physical lengths should have been adapted
inquire join(attributephysicallength,relation(heading(attributename(name))body(tuple(attributename(dbmatt_shtring))tuple(attributename(dbmatt_splong))tuple(attributename(dbmatt_angle)))))

* change back to FL type without removing logical length - should fail
update attribute,attribute(tuple(attributename(dbmatt_splong)typename(shtring))),(typename(angle))

* change back to FL type while removing logical length - should pass
cmd( |>
update attribute,attribute(tuple(attributename(dbmatt_splong)typename(shtring))),(typename(angleinterval)) |>
) |>
cmd( |>
delete attributelogicallength,attributelogicallength(tuple(attributename(dbmatt_splong)logicallength(2500))) |>
) 

* physical lengths should have been adapted
inquire join(attributephysicallength,relation(heading(attributename(name))body(tuple(attributename(dbmatt_shtring))tuple(attributename(dbmatt_splong))tuple(attributename(dbmatt_angle)))))

* clean up
unassert attribute,attribute( |>
tuple(attributename(dbmatt_splong)typename(angleinterval)) |>
)

unassert constrainedtype,constrainedtype(tuple(typename(splong)sp_expression( gt\(parameter\(v\(long\)\),long\(0\) \) )basetype(long)))
unassert constrainedtype,constrainedtype(tuple(typename(shtring)sp_expression( gt\(int\(4800\),length\(parameter\(v\(string\)\)\) \) )basetype(string)))

