* Charset=windows-1252
* test cases for managing tuple constraints

* define the attributes used in the test
assert attribute,attribute( |>
tuple(attributename(int1)typename(int)) |>
tuple(attributename(int2)typename(int)) |>
tuple(attributename(int3)typename(int)) |>
tuple(attributename(int4)typename(int)) |>
tuple(attributename(ii1)typename(intinterval)) |>
tuple(attributename(ii2)typename(intinterval)) |>
)

* define the logical design of the relvars used in the test
cmd( |>
assert relvar,relvar( |>
tuple(relvarname(dbmtc1)relvarpredicate(integers int1, int2, int3, int4.)) |>
tuple(relvarname(dbmtc2)relvarpredicate(integers  int1, int2 and intervals ii1, ii2.)) |>
) |>
) |>
cmd( |>
assert relvarattribute,relvarattribute( |>
tuple(relvarname(dbmtc1)attributename(int1)) |>
tuple(relvarname(dbmtc1)attributename(int2)) |>
tuple(relvarname(dbmtc1)attributename(int3)) |>
tuple(relvarname(dbmtc1)attributename(int4)) |>
tuple(relvarname(dbmtc2)attributename(int1)) |>
tuple(relvarname(dbmtc2)attributename(int2)) |>
tuple(relvarname(dbmtc2)attributename(ii1)) |>
tuple(relvarname(dbmtc2)attributename(ii2)) |>
) |>
)

* define the storage resources used in the test
cmd( |>
assert dbmsfile,dbmsfile( |>
tuple(filename(dbmtc.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
assert storagespace,storagespace( |>
tuple(filename(dbmtc.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(dbmtc.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
assert dataspace,dataspace( |>
tuple(filename(dbmtc.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert multihashingindexspace,multihashingindexspace( |>
tuple(filename(dbmtc.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

* define the physical design of the relvars used in the test
cmd( |>
assert recordtype,recordtype( |>
tuple(filename(dbmtc.spdb)storagespaceid(1)recordtypename(r_dbmtc1)indexname(l_r_dbmtc1)relvarname(dbmtc1)) |>
tuple(filename(dbmtc.spdb)storagespaceid(1)recordtypename(r_dbmtc2)indexname(l_r_dbmtc2)relvarname(dbmtc2)) |>
) |>
) |>
cmd( |>
assert index,index( |>
tuple(filename(dbmtc.spdb)storagespaceid(2)recordtypename(r_dbmtc1)relvarname(dbmtc1)indexname(l_r_dbmtc1)) |>
tuple(filename(dbmtc.spdb)storagespaceid(2)recordtypename(r_dbmtc2)relvarname(dbmtc2)indexname(l_r_dbmtc2)) |>
) |>
) |>
cmd( |>
assert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbmtc1)relvarname(dbmtc1)attributename(int1)ordinal(10)) |>
tuple(recordtypename(r_dbmtc1)relvarname(dbmtc1)attributename(int2)ordinal(20)) |>
tuple(recordtypename(r_dbmtc1)relvarname(dbmtc1)attributename(int3)ordinal(30)) |>
tuple(recordtypename(r_dbmtc1)relvarname(dbmtc1)attributename(int4)ordinal(40)) |>
tuple(recordtypename(r_dbmtc2)relvarname(dbmtc2)attributename(int1)ordinal(10)) |>
tuple(recordtypename(r_dbmtc2)relvarname(dbmtc2)attributename(int2)ordinal(20)) |>
tuple(recordtypename(r_dbmtc2)relvarname(dbmtc2)attributename(ii1)ordinal(30)) |>
tuple(recordtypename(r_dbmtc2)relvarname(dbmtc2)attributename(ii2)ordinal(40)) |>
) |>
) |>
cmd( |>
assert indexcomponent,indexcomponent( |>
tuple(relvarname(dbmtc1)indexname(l_r_dbmtc1)ordinal(10)sp_expression(int1)) |>
tuple(relvarname(dbmtc2)indexname(l_r_dbmtc2)ordinal(10)sp_expression(int2)) |>
) |>
)

delete dbmtc1,dbmtc1
delete dbmtc2,dbmtc2

commit

* tuple constraint to the effect that int1 must be > int2
add tupleconstraint,tupleconstraint( |>
tuple(errorcode(185001)relvarname(dbmtc1)sp_expression(gt\(int1,int2\))) |>
)

* should fail
add dbmtc1,dbmtc1( |>
tuple(int1(1)int2(1)int3(1)int4(1)) |>
)

* should pass
add dbmtc1,dbmtc1( |>
tuple(int1(3)int2(1)int3(1)int4(1)) |>
)

commit

* delete the constraint back again
delete tupleconstraint,tupleconstraint( |>
tuple(errorcode(185001)relvarname(dbmtc1)sp_expression(gt\(int1,int2\))) |>
)

* add an opposite one, should fail on the existing tuple
add tupleconstraint,tupleconstraint( |>
tuple(errorcode(185001)relvarname(dbmtc1)sp_expression(gt\(int2,int1\))) |>
)

commit

delete dbmtc1,dbmtc1

commit

* relvar now empty, adding the opposite constraint should now pass
add tupleconstraint,tupleconstraint( |>
tuple(errorcode(185001)relvarname(dbmtc1)sp_expression(gt\(int2,int1\))) |>
)

commit

* should fail
add dbmtc1,dbmtc1( |>
tuple(int1(1)int2(1)int3(1)int4(1)) |>
)

* should pass
add dbmtc1,dbmtc1( |>
tuple(int1(1)int2(3)int3(1)int4(1)) |>
)

commit

* test cases with interval types (which are special due to the autopack), when these interval values originate from scalar operator invocations

* tuple constraint to the effect that [int1-int2[ doesn't overlap with [int3-int4[ ; should pass with current value
add tupleconstraint,tupleconstraint( |>
tuple(errorcode(185002)relvarname(dbmtc1)sp_expression(not\(overlaps\(intinterval\(begin\(int3\)end\(int4\)\),intinterval\(begin\(int1\)end\(int2\)\)\)\))) |>
)

commit

* should fail
add dbmtc1,dbmtc1( |>
tuple(int1(1)int2(7)int3(-1)int4(2)) |>
)

* should pass
add dbmtc1,dbmtc1( |>
tuple(int1(1)int2(7)int3(-1)int4(1)) |>
)

commit

* now with the relvar that has interval-typed attributes

* tuple constraint to the effect that length(ii1) = length(ii2)
add tupleconstraint,tupleconstraint( |>
tuple(errorcode(185003)relvarname(dbmtc2)sp_expression(eq\(length\(ii1\),length\(ii2\)\))) |>
)

commit

* should fail
add dbmtc2,dbmtc2( |>
tuple(int1(1)int2(7)ii1(begin(2)end(4))ii2(begin(1)end(4))) |>
)

* should pass
add dbmtc2,dbmtc2( |>
tuple(int1(1)int2(7)ii1(begin(2)end(4))ii2(begin(1)end(3))) |>
)

* should fail
add dbmtc2,dbmtc2( |>
tuple(int1(1)int2(7)ii1(begin(4)end(6))ii2(begin(1)end(3))) |>
)

* should pass
assert dbmtc2,dbmtc2( |>
tuple(int1(1)int2(7)ii1(begin(4)end(6))ii2(begin(1)end(5))) |>
tuple(int1(1)int2(7)ii1(begin(2)end(4))ii2(begin(3)end(5))) |>
)

commit

delete dbmtc1,dbmtc1
delete dbmtc2,dbmtc2

commit

delete tupleconstraint,semijoin(tupleconstraint,relation( |>
heading(errorcode(long))body(tuple(errorcode(185001))tuple(errorcode(185002))tuple(errorcode(185003))) |>
) |>
)

commit

* remove the physical design of the relvars used in the test
cmd( |>
unassert recordtype,recordtype( |>
tuple(filename(dbmtc.spdb)storagespaceid(1)recordtypename(r_dbmtc1)indexname(l_r_dbmtc1)relvarname(dbmtc1)) |>
tuple(filename(dbmtc.spdb)storagespaceid(1)recordtypename(r_dbmtc2)indexname(l_r_dbmtc2)relvarname(dbmtc2)) |>
) |>
) |>
cmd( |>
unassert index,index( |>
tuple(filename(dbmtc.spdb)storagespaceid(2)recordtypename(r_dbmtc1)relvarname(dbmtc1)indexname(l_r_dbmtc1)) |>
tuple(filename(dbmtc.spdb)storagespaceid(2)recordtypename(r_dbmtc2)relvarname(dbmtc2)indexname(l_r_dbmtc2)) |>
) |>
) |>
cmd( |>
unassert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbmtc1)relvarname(dbmtc1)attributename(int1)ordinal(10)) |>
tuple(recordtypename(r_dbmtc1)relvarname(dbmtc1)attributename(int2)ordinal(20)) |>
tuple(recordtypename(r_dbmtc1)relvarname(dbmtc1)attributename(int3)ordinal(30)) |>
tuple(recordtypename(r_dbmtc1)relvarname(dbmtc1)attributename(int4)ordinal(40)) |>
tuple(recordtypename(r_dbmtc2)relvarname(dbmtc2)attributename(int1)ordinal(10)) |>
tuple(recordtypename(r_dbmtc2)relvarname(dbmtc2)attributename(int2)ordinal(20)) |>
tuple(recordtypename(r_dbmtc2)relvarname(dbmtc2)attributename(ii1)ordinal(30)) |>
tuple(recordtypename(r_dbmtc2)relvarname(dbmtc2)attributename(ii2)ordinal(40)) |>
) |>
) |>
cmd( |>
unassert indexcomponent,indexcomponent( |>
tuple(relvarname(dbmtc1)indexname(l_r_dbmtc1)ordinal(10)sp_expression(int1)) |>
tuple(relvarname(dbmtc2)indexname(l_r_dbmtc2)ordinal(10)sp_expression(int2)) |>
) |>
)

* remove the storage resources used in the test
cmd( |>
unassert dbmsfile,dbmsfile( |>
tuple(filename(dbmtc.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
unassert storagespace,storagespace( |>
tuple(filename(dbmtc.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(dbmtc.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
unassert dataspace,dataspace( |>
tuple(filename(dbmtc.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert multihashingindexspace,multihashingindexspace( |>
tuple(filename(dbmtc.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

* remove the logical design of the relvars used in the test
cmd( |>
unassert relvar,relvar( |>
tuple(relvarname(dbmtc1)relvarpredicate(integers int1, int2, int3, int4.)) |>
tuple(relvarname(dbmtc2)relvarpredicate(integers  int1, int2 and intervals ii1, ii2.)) |>
) |>
) |>
cmd( |>
unassert relvarattribute,relvarattribute( |>
tuple(relvarname(dbmtc1)attributename(int1)) |>
tuple(relvarname(dbmtc1)attributename(int2)) |>
tuple(relvarname(dbmtc1)attributename(int3)) |>
tuple(relvarname(dbmtc1)attributename(int4)) |>
tuple(relvarname(dbmtc2)attributename(int1)) |>
tuple(relvarname(dbmtc2)attributename(int2)) |>
tuple(relvarname(dbmtc2)attributename(ii1)) |>
tuple(relvarname(dbmtc2)attributename(ii2)) |>
) |>
)

* remove the attributes used in the test
unassert attribute,semiminus(attribute( |>
tuple(attributename(int1)typename(int)) |>
tuple(attributename(int2)typename(int)) |>
tuple(attributename(int3)typename(int)) |>
tuple(attributename(int4)typename(int)) |>
tuple(attributename(ii1)typename(intinterval)) |>
tuple(attributename(ii2)typename(intinterval)) |>
),relvarattribute)
