* Charset=windows-1252
* test-cases for non-user-related transaction constraints
assert attribute,attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
tuple(attributename(scalar3)typename(long)) |>
tuple(attributename(scalar4)typename(long)) |>
)

cmd( |>
assert relvar,relvar( |>
tuple(relvarname(dbmtda)relvarpredicate(scalar1 and scalar2.)) |>
tuple(relvarname(dbmtdar)relvarpredicate(sum scalar3 and difference scalar4.)) |>
) |>
) |>
cmd( |>
assert relvarattribute,relvarattribute( |>
tuple(relvarname(dbmtda)attributename(scalar1)) |>
tuple(relvarname(dbmtda)attributename(scalar2)) |>
tuple(relvarname(dbmtdar)attributename(scalar3)) |>
tuple(relvarname(dbmtdar)attributename(scalar4)) |>
) |>
)

cmd( |>
assert dbmsfile,dbmsfile( |>
tuple(filename(dbmtda.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
assert storagespace,storagespace( |>
tuple(filename(dbmtda.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(dbmtda.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
assert dataspace,dataspace( |>
tuple(filename(dbmtda.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert multihashingindexspace,multihashingindexspace( |>
tuple(filename(dbmtda.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

cmd( |>
assert recordtype,recordtype( |>
tuple(indexname(l_r_dbmtda)filename(dbmtda.spdb)storagespaceid(1)recordtypename(r_dbmtda)relvarname(dbmtda)) |>
tuple(indexname(l_r_dbmtdar)filename(dbmtda.spdb)storagespaceid(1)recordtypename(r_dbmtdar)relvarname(dbmtdar)) |>
) |>
) |>
cmd( |>
assert index,index( |>
tuple(filename(dbmtda.spdb)storagespaceid(2)recordtypename(r_dbmtda)relvarname(dbmtda)indexname(l_r_dbmtda)) |>
tuple(filename(dbmtda.spdb)storagespaceid(2)recordtypename(r_dbmtdar)relvarname(dbmtdar)indexname(l_r_dbmtdar)) |>
) |>
) |>
cmd( |>
assert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbmtda)relvarname(dbmtda)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_dbmtda)relvarname(dbmtda)attributename(scalar2)ordinal(20)) |>
tuple(recordtypename(r_dbmtdar)relvarname(dbmtdar)attributename(scalar3)ordinal(10)) |>
tuple(recordtypename(r_dbmtdar)relvarname(dbmtdar)attributename(scalar4)ordinal(20)) |>
) |>
) |>
cmd( |>
assert indexcomponent,indexcomponent( |>
tuple(relvarname(dbmtda)indexname(l_r_dbmtda)ordinal(10)sp_expression(scalar1)) |>
tuple(relvarname(dbmtda)indexname(l_r_dbmtda)ordinal(20)sp_expression(scalar2)) |>
tuple(relvarname(dbmtdar)indexname(l_r_dbmtdar)ordinal(10)sp_expression(scalar3)) |>
tuple(relvarname(dbmtdar)indexname(l_r_dbmtdar)ordinal(20)sp_expression(scalar4)) |>
) |>
)

* test-cases for triggered data actions
delete dbmtda,dbmtda
delete dbmtdar,dbmtdar
commit

assert triggereddataaction,triggereddataaction( |>
tuple(relvarname(dbmtda)targetrelvarname(dbmtdar)dataactionname(aa)operationtype(2)triggeredoperationtype(2)bypassassgconstraints(false)isdistinct(false)sp_expression(transform\(inserts\(dbmtda\),\(scalar3\(plus\(scalar1,scalar2\)\),scalar4\(sub\(scalar1,scalar2\)\)\)\))) |>
)
commit

add dbmtda,dbmtda(tuple(scalar1(5)scalar2(3)))
inquire dbmtda
inquire dbmtdar
commit

* test the distinctness rule for the target : should pass
add dbmtdar,dbmtdar(tuple(scalar3(5)scalar4(3)))
add dbmtda,dbmtda(tuple(scalar1(4)scalar2(1)))
inquire dbmtda
inquire dbmtdar
rollback

* now set the action to be distinct on the target
update triggereddataaction,restrict(triggereddataaction,eq(dataactionname,name(aa))),(isdistinct(true))

* test the distinctness rule for the target : should now fail
add dbmtdar,dbmtdar(tuple(scalar3(5)scalar4(3)))
add dbmtda,dbmtda(tuple(scalar1(4)scalar2(1)))
inquire dbmtda
inquire dbmtdar
rollback

* test the bypass constraints rule : add a prohibitive assignment constraint to dbmtdar
assert assignmentconstraint,assignmentconstraint( |>
tuple(constraintlabel(nothing goes in)errorcode(181011)sp_expression(insertssac\(dbmtdar\))) |>
)
assert assignmentconstraintcheck,assignmentconstraintcheck( |>
tuple(relvarname(dbmtdar)operationtype(2)errorcode(181011)) |>
)
commit

inquire dbmtda
inquire dbmtdar
* now any add should fail
add dbmtda,dbmtda(tuple(scalar1(4)scalar2(1)))
inquire dbmtda
inquire dbmtdar
add dbmtda,dbmtda(tuple(scalar1(14)scalar2(11)))
inquire dbmtda
inquire dbmtdar
rollback

* now set action to bypass assignment constraints
update triggereddataaction,restrict(triggereddataaction,eq(dataactionname,name(aa))),(bypassassgconstraints(true))
commit

* now add should pass
add dbmtda,dbmtda(tuple(scalar1(4)scalar2(1)))
inquire dbmtda
inquire dbmtdar
add dbmtda,dbmtda(tuple(scalar1(14)scalar2(11)))
inquire dbmtda
inquire dbmtdar
commit

* clear the assignment constraint
unassert assignmentconstraintcheck,assignmentconstraintcheck( |>
tuple(relvarname(dbmtdar)operationtype(2)errorcode(181011)) |>
)
unassert assignmentconstraint,assignmentconstraint( |>
tuple(constraintlabel(nothing goes in)errorcode(181011)sp_expression(insertssac\(dbmtdar\))) |>
)
commit

* clear the action
delete triggereddataaction,restrict(triggereddataaction,eq(dataactionname,name(aa)))
commit

* clear the data
delete dbmtda,dbmtda
delete dbmtdar,dbmtdar
commit

* test cases for using virtual relvars in triggered data actions

delete dbmtda,dbmtda
delete dbmtdar,dbmtdar
commit

* viewexpression : update if it exists, assert if it doesn't
update virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrttda1))),(sp_expression(string(table_dum)))
assert virtualrelvar,virtualrelvar(tuple(relvarname(v_vrttda1)sp_expression(string(table_dum))))

assert triggereddataaction,triggereddataaction( |>
tuple(relvarname(dbmtda)targetrelvarname(dbmtdar)dataactionname(aa)operationtype(2)triggeredoperationtype(2)bypassassgconstraints(false)isdistinct(false)sp_expression(transform\(join\(v_vrttda1,inserts\(dbmtda\)\),\(scalar3\(plus\(scalar1,scalar2\)\),scalar4\(sub\(scalar1,scalar2\)\)\)\))) |>
)
commit

* do an insert - no triggered insert should appear in trgda1r
add dbmtda,dbmtda(tuple(scalar1(5)scalar2(3)))
inquire dbmtda
inquire dbmtdar
commit

* update the view
update virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrttda1))),(sp_expression(string(table_dee)))
commit

* do an insert - one triggered insert should appear in trgda1r
add dbmtda,dbmtda(tuple(scalar1(15)scalar2(13)))
inquire dbmtda
inquire dbmtdar
commit

* now test mith multiple levels of nested views - assert second view (update if it exists - create if it doesn't)
update virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrttda2))),(sp_expression(string(table_dee)))
assert virtualrelvar,virtualrelvar(tuple(relvarname(v_vrttda2)sp_expression(string(table_dee))))

* change v1 expression to reference v2
update virtualrelvar,virtualrelvar(tuple(relvarname(v_vrttda1)sp_expression(string(table_dee)))),(sp_expression(string(v_vrttda2)))
commit

* do an insert - one triggered insert should appear in trgda1r
add dbmtda,dbmtda(tuple(scalar1(25)scalar2(23)))
inquire dbmtda
inquire dbmtdar
commit

* change v2 view to dum
update virtualrelvar,restrict(virtualrelvar,eq(relvarname,name(v_vrttda2))),(sp_expression(string(table_dum)))
commit

* do an insert - no triggered insert should appear in trgda1r
add dbmtda,dbmtda(tuple(scalar1(35)scalar2(33)))
inquire dbmtda
inquire dbmtdar
commit

* clear the view - should fail on being used by tda
delete virtualrelvar,restrict(virtualrelvar,matches(the_string(relvarname),string(V_VRTTDA.*)))
commit

* clear the action
delete triggereddataaction,restrict(triggereddataaction,eq(dataactionname,name(aa)))
commit

* clear the view - should now succeed
delete virtualrelvar,restrict(virtualrelvar,matches(the_string(relvarname),string(V_VRTTDA.*)))
commit

* clear the data
delete dbmtda,dbmtda
delete dbmtdar,dbmtdar
commit

* test-cases for non-user-related transaction constraints
cmd( |>
unassert recordtype,recordtype( |>
tuple(indexname(l_r_dbmtda)filename(dbmtda.spdb)storagespaceid(1)recordtypename(r_dbmtda)relvarname(dbmtda)) |>
tuple(indexname(l_r_dbmtdar)filename(dbmtda.spdb)storagespaceid(1)recordtypename(r_dbmtdar)relvarname(dbmtdar)) |>
) |>
) |>
cmd( |>
unassert index,index( |>
tuple(filename(dbmtda.spdb)storagespaceid(2)recordtypename(r_dbmtda)relvarname(dbmtda)indexname(l_r_dbmtda)) |>
tuple(filename(dbmtda.spdb)storagespaceid(2)recordtypename(r_dbmtdar)relvarname(dbmtdar)indexname(l_r_dbmtdar)) |>
) |>
) |>
cmd( |>
unassert recordattribute,recordattribute( |>
tuple(recordtypename(r_dbmtda)relvarname(dbmtda)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_dbmtda)relvarname(dbmtda)attributename(scalar2)ordinal(20)) |>
tuple(recordtypename(r_dbmtdar)relvarname(dbmtdar)attributename(scalar3)ordinal(10)) |>
tuple(recordtypename(r_dbmtdar)relvarname(dbmtdar)attributename(scalar4)ordinal(20)) |>
) |>
) |>
cmd( |>
unassert indexcomponent,indexcomponent( |>
tuple(relvarname(dbmtda)indexname(l_r_dbmtda)ordinal(10)sp_expression(scalar1)) |>
tuple(relvarname(dbmtda)indexname(l_r_dbmtda)ordinal(20)sp_expression(scalar2)) |>
tuple(relvarname(dbmtdar)indexname(l_r_dbmtdar)ordinal(10)sp_expression(scalar3)) |>
tuple(relvarname(dbmtdar)indexname(l_r_dbmtdar)ordinal(20)sp_expression(scalar4)) |>
) |>
)

cmd( |>
unassert dbmsfile,dbmsfile( |>
tuple(filename(dbmtda.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
unassert storagespace,storagespace( |>
tuple(filename(dbmtda.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(dbmtda.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
unassert dataspace,dataspace( |>
tuple(filename(dbmtda.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert multihashingindexspace,multihashingindexspace( |>
tuple(filename(dbmtda.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

cmd( |>
unassert relvar,relvar( |>
tuple(relvarname(dbmtda)relvarpredicate(scalar1 and scalar2.)) |>
tuple(relvarname(dbmtdar)relvarpredicate(sum scalar3 and difference scalar4.)) |>
) |>
) |>
cmd( |>
unassert relvarattribute,relvarattribute( |>
tuple(relvarname(dbmtda)attributename(scalar1)) |>
tuple(relvarname(dbmtda)attributename(scalar2)) |>
tuple(relvarname(dbmtdar)attributename(scalar3)) |>
tuple(relvarname(dbmtdar)attributename(scalar4)) |>
) |>
)

unassert attribute,semiminus(attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
tuple(attributename(scalar3)typename(long)) |>
tuple(attributename(scalar4)typename(long)) |>
),relvarattribute)
