* Charset=windows-1252
* test cases for the escape syntax of the language

cmd( |>
assert attribute,attribute( |>
tuple(attributename(str1)typename(string)) |>
tuple(attributename(str2)typename(string)) |>
) |>
) |>
cmd( |>
assert attributelogicallength,attributelogicallength( |>
tuple(attributename(str1)logicallength(12)) |>
tuple(attributename(str2)logicallength(16)) |>
) |>
) |>
cmd( |>
assert relvar,relvar( |>
tuple(relvarname(esc1)relvarpredicate(str1 and str2.)) |>
) |>
) |>
cmd( |>
assert relvarattribute,relvarattribute( |>
tuple(relvarname(esc1)attributename(str1)) |>
tuple(relvarname(esc1)attributename(str2)) |>
) |>
)

cmd( |>
assert storagespace,storagespace( |>
tuple(filename(esc1a.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(esc1a.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
assert dataspace,dataspace( |>
tuple(filename(esc1a.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert dbmsfile,dbmsfile( |>
tuple(filename(esc1a.spdb)pagesize(16384))) |>
) |>
) |>
cmd( |>
assert multihashingindexspace,multihashingindexspace( |>
tuple(filename(esc1a.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

cmd( |>
assert recordtype,recordtype( |>
tuple(filename(esc1a.spdb)storagespaceid(1)indexname(loc1esc1)recordtypename(esc1)relvarname(esc1)) |>
) |>
) |>
cmd( |>
assert index,index( |>
tuple(filename(esc1a.spdb)storagespaceid(2)recordtypename(esc1)relvarname(esc1)indexname(loc1esc1)) |>
) |>
) |>
cmd( |>
assert recordattribute,recordattribute( |>
tuple(recordtypename(esc1)relvarname(esc1)attributename(str1)ordinal(10)) |>
tuple(recordtypename(esc1)relvarname(esc1)attributename(str2)ordinal(20)) |>
) |>
) |>
cmd( |>
assert indexcomponent,indexcomponent( |>
tuple(relvarname(esc1)indexname(loc1esc1)ordinal(10)sp_expression(str1)) |>
) |>
)

* clear variable
delete esc1,esc1
* add a tuple with empty strings
add esc1,esc1(tuple(str1()str2()))
inquire esc1
* add a tuple with strings containing no metalanguage tokens
assert esc1,esc1(tuple(str1(abc)str2(def)))
inquire esc1
* prevent rollback
commit
* add too long strings
assert esc1,esc1(tuple(str1(abcdefghijklmnop)str2(abcdefghijkl)))
* add too long strings
assert esc1,esc1(tuple(str1(abcdefghijkl)str2(abcdefghijklmnopqrst)))
* add maximum-length strings
assert esc1,esc1(tuple(str1(abcdefghijkl)str2(abcdefghijklmnop)))
inquire esc1
* prevent rollback
commit
* escape tests : bracket count matches, syntax wrong nevertheless
assert esc1,esc1(tuple(str1())str2(()))
* escape tests : bracket count matches, syntax wrong nevertheless
assert esc1,esc1(tuple(str1(()str2())))
* escape tests : this one should be good
assert esc1,esc1(tuple(str1(\()str2(\))))
inquire esc1
* prevent rollback
commit
* escape tests : invalid backslash
assert esc1,esc1(tuple(str1(\a)str2(\b)))
* escape tests : valid backslash
assert esc1,esc1(tuple(str1(\\a)str2(\\b)))
inquire esc1
* prevent rollback
commit
* clear variable
delete esc1,esc1
commit

cmd( |>
unassert recordtype,recordtype( |>
tuple(filename(esc1a.spdb)storagespaceid(1)indexname(loc1esc1)recordtypename(esc1)relvarname(esc1)) |>
) |>
) |>
cmd( |>
unassert index,index( |>
tuple(filename(esc1a.spdb)storagespaceid(2)recordtypename(esc1)relvarname(esc1)indexname(loc1esc1)) |>
) |>
) |>
cmd( |>
unassert recordattribute,recordattribute( |>
tuple(recordtypename(esc1)relvarname(esc1)attributename(str1)ordinal(10)) |>
tuple(recordtypename(esc1)relvarname(esc1)attributename(str2)ordinal(20)) |>
) |>
) |>
cmd( |>
unassert indexcomponent,indexcomponent( |>
tuple(relvarname(esc1)indexname(loc1esc1)ordinal(10)sp_expression(str1)) |>
) |>
)

cmd( |>
unassert storagespace,storagespace( |>
tuple(filename(esc1a.spdb)extentscount(2)pagecount(20)storagespaceid(1)) |>
tuple(filename(esc1a.spdb)extentscount(2)pagecount(20)storagespaceid(2)) |>
) |>
) |>
cmd( |>
unassert dataspace,dataspace( |>
tuple(filename(esc1a.spdb)storagespaceid(1)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert dbmsfile,dbmsfile( |>
tuple(filename(esc1a.spdb)pagesize(16384))) |>
) |>
) |>
cmd( |>
unassert multihashingindexspace,multihashingindexspace( |>
tuple(filename(esc1a.spdb)storagespaceid(2)gapcompressionthreshold(5)maximumgaps(9)) |>
) |>
)

cmd( |>
unassert relvar,relvar( |>
tuple(relvarname(esc1)relvarpredicate(record with str1 and str2.)) |>
) |>
) |>
cmd( |>
unassert relvarattribute,relvarattribute( |>
tuple(relvarname(esc1)attributename(str1)) |>
tuple(relvarname(esc1)attributename(str2)) |>
) |>
)

cmd( |>
unassert attribute,semiminus(attribute( |>
tuple(attributename(str1)typename(string)) |>
tuple(attributename(str2)typename(string)) |>
),relvarattribute) |>
) |>
cmd( |>
unassert attributelogicallength,semiminus(attributelogicallength( |>
tuple(attributename(str1)logicallength(12)) |>
tuple(attributename(str2)logicallength(16)) |>
),relvarattribute) |>
)
