* Charset=windows-1252
* test-cases for page compression
assert attribute,attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
)

cmd( |>
assert relvar,relvar( |>
tuple(relvarname(pgcmpr)relvarpredicate(scalar1 and scalar2.)) |>
) |>
) |>
cmd( |>
assert relvarattribute,relvarattribute( |>
tuple(relvarname(pgcmpr)attributename(scalar1)) |>
tuple(relvarname(pgcmpr)attributename(scalar2)) |>
) |>
)

cmd( |>
assert dbmsfile,dbmsfile( |>
tuple(filename(pgcmpr.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
assert storagespace,storagespace( |>
tuple(filename(pgcmpr.spdb)extentscount(2)pagecount(3)storagespaceid(1)) |>
tuple(filename(pgcmpr.spdb)extentscount(2)pagecount(3)storagespaceid(2)) |>
tuple(filename(pgcmpr.spdb)extentscount(2)pagecount(3)storagespaceid(3)) |>
) |>
) |>
cmd( |>
assert dataspace,dataspace( |>
tuple(filename(pgcmpr.spdb)storagespaceid(1)gapcompressionthreshold(3)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert multihashingindexspace,multihashingindexspace( |>
tuple(filename(pgcmpr.spdb)storagespaceid(2)gapcompressionthreshold(3)maximumgaps(9)) |>
) |>
) |>
cmd( |>
assert hashingindexspace,hashingindexspace( |>
tuple(filename(pgcmpr.spdb)storagespaceid(3)) |>
) |>
)

cmd( |>
assert recordtype,recordtype( |>
tuple(indexname(l_r_pgcmpr)filename(pgcmpr.spdb)storagespaceid(1)recordtypename(r_pgcmpr)relvarname(pgcmpr)) |>
) |>
) |>
cmd( |>
assert index,index( |>
tuple(filename(pgcmpr.spdb)storagespaceid(2)recordtypename(r_pgcmpr)relvarname(pgcmpr)indexname(l_r_pgcmpr)) |>
tuple(filename(pgcmpr.spdb)storagespaceid(3)recordtypename(r_pgcmpr)relvarname(pgcmpr)indexname(r_pgcmpr)) |>
) |>
) |>
cmd( |>
assert recordattribute,recordattribute( |>
tuple(recordtypename(r_pgcmpr)relvarname(pgcmpr)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_pgcmpr)relvarname(pgcmpr)attributename(scalar2)ordinal(20)) |>
) |>
) |>
cmd( |>
assert indexcomponent,indexcomponent( |>
tuple(relvarname(pgcmpr)indexname(l_r_pgcmpr)ordinal(10)sp_expression(scalar1)) |>
tuple(relvarname(pgcmpr)indexname(r_pgcmpr)ordinal(20)sp_expression(scalar2)) |>
) |>
)

delete pgcmpr,pgcmpr
commit

* fill a bunch
add pgcmpr,pgcmpr( |>
tuple(scalar1(1)scalar2(2)) |>
tuple(scalar1(3)scalar2(4)) |>
tuple(scalar1(5)scalar2(6)) |>
tuple(scalar1(7)scalar2(8)) |>
tuple(scalar1(9)scalar2(0)) |>
tuple(scalar1(11)scalar2(12)) |>
tuple(scalar1(13)scalar2(14)) |>
tuple(scalar1(15)scalar2(16)) |>
tuple(scalar1(17)scalar2(18)) |>
tuple(scalar1(19)scalar2(10)) |>
tuple(scalar1(21)scalar2(22)) |>
tuple(scalar1(23)scalar2(24)) |>
tuple(scalar1(25)scalar2(26)) |>
tuple(scalar1(27)scalar2(28)) |>
tuple(scalar1(29)scalar2(20)) |>
tuple(scalar1(31)scalar2(32)) |>
tuple(scalar1(33)scalar2(34)) |>
tuple(scalar1(35)scalar2(36)) |>
tuple(scalar1(37)scalar2(38)) |>
tuple(scalar1(39)scalar2(30)) |>
tuple(scalar1(41)scalar2(42)) |>
tuple(scalar1(43)scalar2(44)) |>
tuple(scalar1(45)scalar2(46)) |>
tuple(scalar1(47)scalar2(48)) |>
tuple(scalar1(49)scalar2(40)) |>
tuple(scalar1(51)scalar2(52)) |>
tuple(scalar1(53)scalar2(54)) |>
tuple(scalar1(55)scalar2(56)) |>
tuple(scalar1(57)scalar2(58)) |>
tuple(scalar1(59)scalar2(50)) |>
)
commit

* delete a bunch
delete pgcmpr,pgcmpr( |>
tuple(scalar1(5)scalar2(6)) |>
tuple(scalar1(15)scalar2(16)) |>
tuple(scalar1(25)scalar2(26)) |>
tuple(scalar1(35)scalar2(36)) |>
tuple(scalar1(37)scalar2(38)) |>
tuple(scalar1(45)scalar2(46)) |>
tuple(scalar1(55)scalar2(56)) |>
tuple(scalar1(43)scalar2(44)) |>
tuple(scalar1(23)scalar2(24)) |>
)
commit

* now see what remains
inquire pgcmpr
inquire project(pgcmpr,(scalar1))
inquire project(pgcmpr,(scalar2))
inquire aggregate(project(pgcmpr,(scalar1)),sum1(plus(scalar1)))
inquire aggregate(pgcmpr,sum1(plus(scalar1)))
inquire aggregate(project(pgcmpr,(scalar2)),sum2(plus(scalar2)))
inquire aggregate(pgcmpr,sum2(plus(scalar2)))
inquire restrict(pgcmpr,eq(scalar1,long(25)))
inquire restrict(pgcmpr,eq(scalar2,long(26)))
inquire restrict(pgcmpr,eq(scalar1,long(27)))
inquire restrict(pgcmpr,eq(scalar2,long(28)))
commit

delete pgcmpr,pgcmpr
commit

cmd( |>
unassert recordtype,recordtype( |>
tuple(indexname(l_r_pgcmpr)filename(pgcmpr.spdb)storagespaceid(1)recordtypename(r_pgcmpr)relvarname(pgcmpr)) |>
) |>
) |>
cmd( |>
unassert index,index( |>
tuple(filename(pgcmpr.spdb)storagespaceid(2)recordtypename(r_pgcmpr)relvarname(pgcmpr)indexname(l_r_pgcmpr)) |>
tuple(filename(pgcmpr.spdb)storagespaceid(3)recordtypename(r_pgcmpr)relvarname(pgcmpr)indexname(r_pgcmpr)) |>
) |>
) |>
cmd( |>
unassert recordattribute,recordattribute( |>
tuple(recordtypename(r_pgcmpr)relvarname(pgcmpr)attributename(scalar1)ordinal(10)) |>
tuple(recordtypename(r_pgcmpr)relvarname(pgcmpr)attributename(scalar2)ordinal(20)) |>
) |>
) |>
cmd( |>
unassert indexcomponent,indexcomponent( |>
tuple(relvarname(pgcmpr)indexname(l_r_pgcmpr)ordinal(10)sp_expression(scalar1)) |>
tuple(relvarname(pgcmpr)indexname(r_pgcmpr)ordinal(20)sp_expression(scalar2)) |>
) |>
)

cmd( |>
unassert relvar,relvar( |>
tuple(relvarname(pgcmpr)relvarpredicate(scalar1 and scalar2.)) |>
) |>
) |>
cmd( |>
unassert relvarattribute,relvarattribute( |>
tuple(relvarname(pgcmpr)attributename(scalar1)) |>
tuple(relvarname(pgcmpr)attributename(scalar2)) |>
) |>
)

cmd( |>
unassert dbmsfile,dbmsfile( |>
tuple(filename(pgcmpr.spdb)pagesize(8192)) |>
) |>
) |>
cmd( |>
unassert storagespace,storagespace( |>
tuple(filename(pgcmpr.spdb)extentscount(2)pagecount(3)storagespaceid(1)) |>
tuple(filename(pgcmpr.spdb)extentscount(2)pagecount(3)storagespaceid(2)) |>
tuple(filename(pgcmpr.spdb)extentscount(2)pagecount(3)storagespaceid(3)) |>
) |>
) |>
cmd( |>
unassert dataspace,dataspace( |>
tuple(filename(pgcmpr.spdb)storagespaceid(1)gapcompressionthreshold(3)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert multihashingindexspace,multihashingindexspace( |>
tuple(filename(pgcmpr.spdb)storagespaceid(2)gapcompressionthreshold(3)maximumgaps(9)) |>
) |>
) |>
cmd( |>
unassert hashingindexspace,hashingindexspace( |>
tuple(filename(pgcmpr.spdb)storagespaceid(3)) |>
) |>
)

* clear the attributes
unassert attribute,semiminus(attribute( |>
tuple(attributename(scalar1)typename(long)) |>
tuple(attributename(scalar2)typename(long)) |>
),relvarattribute)

