/*
 * Created on 10-sep-2007
 */
package be.SIRAPRISE.webclient;

import java.util.Locale;

import be.WAAR.PresentationLayer.WAARApplicationException;
import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
class AssignmentConstraintCheckNotFoundException extends WAARApplicationException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1822136459375377556L;

	/**
	 * Creates the exception
	 * 
	 * @param errorCode
	 *            The error code that was not found
	 * @param operationType
	 *            The operation type for which no assignment constraint check was found
	 * @param relvarName
	 *            the relvar name for which no assignment constraint check was found
	 * @param locale
	 *            The user locale in which to set the message text
	 */
	AssignmentConstraintCheckNotFoundException (long errorCode, String relvarName, String operationType, Locale locale) {
		super(MyMessageFormat.format(I18N.getString(locale, "AssignmentConstraintCheckNotFoundException.Text"), new String[] { Long.toString(errorCode), relvarName, operationType })); //$NON-NLS-1$
	}
}