package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.AssignmentConstraintCheck;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete an assignment constraint check
 * 
 * @author Erwin
 */
public class AssignmentConstraintChecksDelete extends AssignmentConstraintChecksWebClientFunction {

	/**
	 * 
	 */
	private static final String ASSIGNMENTCONSTRAINTCHECKSSELECT = "AssignmentConstraintChecksSelect"; //$NON-NLS-1$

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedAssignmentConstraintCheck ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		AssignmentConstraintCheck assignmentConstraintCheck = getAssignmentConstraintCheck(sirapriseServer);
		setPresentation("AssignmentConstraintChecksDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.ERRORCODE, assignmentConstraintCheck.getErrorCode());
		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, assignmentConstraintCheck.getRelvarName());
		setPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE, assignmentConstraintCheck.getOperationType());

		saveInFunctionContext(RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK, assignmentConstraintCheck);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null && getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null && getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE) != null) {
			processSelectedAssignmentConstraintCheck();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(ASSIGNMENTCONSTRAINTCHECKSSELECT)) {
			// errorcode entered, ask confirmation
			processSelectedAssignmentConstraintCheck();
		} else {
			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execDmlCommandAndEndTransaction(((AssignmentConstraintCheck) getFromFunctionContextMandatory(RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK)).dbDeleteCommand(RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK)); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return ASSIGNMENTCONSTRAINTCHECKSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "AssignmentConstraintChecksDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}