/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.AssignmentConstraintCheck;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.WAAR.PresentationLayer.GenericLongValue;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.NumberedEnumerationValue;
import be.WAAR.PresentationLayer.WAARApplicationException;

/**
 * @author Erwin
 * 
 */
public abstract class AssignmentConstraintChecksWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String ASSIGNMENTCONSTRAINTSSELECT = "AssignmentConstraintsSelect"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @return
	 * @throws WAARApplicationException
	 */
	final AssignmentConstraintCheck getAssignmentConstraintCheck (SiraPriseServer sirapriseServer) throws WAARApplicationException {
		long errorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger();
		String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString();
		int operationType = ((NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE)).getIntegerValue();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			
			AbstractRelation tuples = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK + "," + ("AND(AND(EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")),EQ(" + ATTRIBUTENAMES.OPERATIONTYPE + ",INT(" + operationType + "))),EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + errorCode + ")))") + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$  //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
			if (tuples.size() < 1) {
				throw new AssignmentConstraintCheckNotFoundException(errorCode, relvarName, new OperationTypeEnum().toString(operationType), getUserLocale());
			}

			return tuples.toObjectCollection(AssignmentConstraintCheck.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}
}
