package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.LinkedList;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.AssignmentConstraint;
import be.SIRAPRISE.client.jsba.AssignmentConstraintCheck;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.util.BracketParser;
import be.WAAR.PresentationLayer.*;

/**
 * Function to add a new assignment constraint
 * 
 * @author Erwin
 */
public class AssignmentConstraintsCreate extends AssignmentConstraintsWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$

			GenericStringValue wv_expression = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION);
			long errorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger();
			LinkedList<DmlAssignmentCommand> cmds = new LinkedList<DmlAssignmentCommand>();
			if (((LogicalValue) getPresentationValue("CREATEDEFAULTCONSTRAINTCHECKS")).getValue()) { //$NON-NLS-1$
				final AbstractRelation defaultAssignmentConstraintChecksRelation = startTransaction.execQuery("UNGROUP(TRANSFORM(PROJECT(EXPRESSIONINFO(STRING(" + BracketParser.meta(wv_expression.getString()) + ")),(INSERTSDELETESINVOCATIONS)),ASSIGNMENTCONSTRAINTCHECKS(JOIN(RELATION(HEADING(ERRORCODE(LONG))BODY(TUPLE(ERRORCODE(LONG(" + errorCode + "))))),INSERTSDELETESINVOCATIONS))),(ASSIGNMENTCONSTRAINTCHECKS))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				final Collection<AssignmentConstraintCheck> defaultAssignmentConstraintCheckObjects = defaultAssignmentConstraintChecksRelation.toObjectCollectionIgnoringMissingSetters(AssignmentConstraintCheck.class);
				for (AssignmentConstraintCheck assignmentConstraintCheck : defaultAssignmentConstraintCheckObjects) {
					cmds.addLast(assignmentConstraintCheck.dbAddCommand());
				}
			}

			GenericStringValue wv_constraintMessageText = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT));
			AssignmentConstraint assignmentConstraint;
			if (wv_constraintMessageText != null) {
				assignmentConstraint = new AssignmentConstraint(wv_expression.getString().trim(), errorCode, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL)).getString().trim(), wv_constraintMessageText.getString().trim());
				cmds.addLast(assignmentConstraint.dbAddCommand(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT));
			} else {
				assignmentConstraint = new AssignmentConstraint(wv_expression.getString().trim(), errorCode, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL)).getString().trim());
			}

			cmds.addLast(assignmentConstraint.dbAddCommand(RELVARNAMES.ASSIGNMENTCONSTRAINT));
			startTransaction.execMultipleStatementAndEndTransaction(cmds);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "AssignmentConstraintsCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}