package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractTuple;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.AssignmentConstraint;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete an assignment constraint and possibly its corresponding constraintmessagetext
 * 
 * @author Erwin
 */
public class AssignmentConstraintsDelete extends AssignmentConstraintsWebClientFunction {

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedAssignmentConstraint ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		AbstractTuple t = (AbstractTuple) getAssignmentConstraint(sirapriseServer, ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger()).iterator().next();
		try {
			AssignmentConstraint assignmentConstraint = DBObjectFactory.getObjectIgnoringMissingSetters(t, AssignmentConstraint.class);

			setPresentation("AssignmentConstraintsDeleteConfirm"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.ERRORCODE, assignmentConstraint.getErrorCode());
			setPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL, assignmentConstraint.getConstraintLabel());
			setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, assignmentConstraint.getConstraintExpression());
			setPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT, assignmentConstraint.getConstraintMessageText());
			setPresentationValue("CHECKS", getWAARListValue("CHECKS", t.rvaValue("CHECKS"), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

			saveInFunctionContext(RELVARNAMES.ASSIGNMENTCONSTRAINT, assignmentConstraint);

		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			processSelectedAssignmentConstraint();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(ASSIGNMENTCONSTRAINTSSELECT)) {
			// errorcode entered, ask confirmation
			processSelectedAssignmentConstraint();
		} else {
			// confirmation entered, delete constraint
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
			AssignmentConstraint assignmentConstraint = (AssignmentConstraint) getFromFunctionContextMandatory(RELVARNAMES.ASSIGNMENTCONSTRAINT);
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new String[] { assignmentConstraint.dbDeleteCommand(RELVARNAMES.ASSIGNMENTCONSTRAINT).getCommand(), assignmentConstraint.dbUnAssertCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT).getCommand(), ("DELETE " + RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK + ",RESTRICT(" + RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK + ",EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + assignmentConstraint.getErrorCode() + ")))") }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return ASSIGNMENTCONSTRAINTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "AssignmentConstraintsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}