package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractTuple;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.DmlMultipleAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.ServerAssignmentCommand;
import be.SIRAPRISE.client.ServerMultipleAssignmentCommand;
import be.SIRAPRISE.client.ServerUpdateCommand;
import be.SIRAPRISE.client.jsba.AssignmentConstraint;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of an assignment constraint
 * 
 * @author Erwin
 */
public class AssignmentConstraintsManage extends AssignmentConstraintsWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processSelectedAssignmentConstraint ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		try {
			AbstractTuple t = (AbstractTuple) getAssignmentConstraint(sirapriseServer, ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger()).iterator().next();
			AssignmentConstraint assignmentConstraint = DBObjectFactory.getObjectIgnoringMissingSetters(t, AssignmentConstraint.class);
			setPresentation("AssignmentConstraintsManageDetails"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.ERRORCODE, assignmentConstraint.getErrorCode());
			setPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL, assignmentConstraint.getConstraintLabel());
			setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, assignmentConstraint.getConstraintExpression());
			setPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT, assignmentConstraint.getConstraintMessageText());

			setPresentationValue("CHECKS", getWAARListValue("CHECKS", t.rvaValue("CHECKS"), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			saveInFunctionContext(RELVARNAMES.ASSIGNMENTCONSTRAINT, assignmentConstraint);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			processSelectedAssignmentConstraint();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(ASSIGNMENTCONSTRAINTSSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedAssignmentConstraint();
		} else {
			// new dbms file details entered, update the catalog
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

			GenericLongValue wv_errorCode = (GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE);
			long errorCode = wv_errorCode.getLonginteger();
			String constraintLabel = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL)).getString().trim();
			String constraintExpression = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim();
			GenericStringValue wv_constraintMessageText = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT);
			String constraintMessageText = wv_constraintMessageText != null ? wv_constraintMessageText.getString().trim() : ""; //$NON-NLS-1$

			AssignmentConstraint assignmentConstraint = (AssignmentConstraint) getFromFunctionContextMandatory(RELVARNAMES.ASSIGNMENTCONSTRAINT);

			assignmentConstraint.setErrorCode(errorCode);
			assignmentConstraint.setConstraintLabel(constraintLabel);
			assignmentConstraint.setConstraintExpression(constraintExpression);
			assignmentConstraint.setConstraintMessageText(constraintMessageText);

			long oldErrorCode = ((AssignmentConstraint) assignmentConstraint.getPreUpdateState()).getErrorCode();

			try {
				DmlAssignmentCommand[] smartUpdateCommand = assignmentConstraint.smartUpdateCommand();
				DBConnection dbc = getDBConnection(sirapriseServer);
				try {
					DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
					if (oldErrorCode == errorCode) {
						// Updates only need to be applied for the ASSIGNMENTCONSTRAINT & CONSTRAINTMESSAGETEXT relvars
						startTransaction.execMultipleStatementAndEndTransaction(smartUpdateCommand);
					} else {
						// Additionally need to cascade the errorCode change to ASSIGNMENTCONSTRAINTCHECKS
						ServerUpdateCommand cascadeToAssignmentConstraintChecks = new ServerUpdateCommand(RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK, "RESTRICT(" + RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK + ",EQ(ERRORCODE,LONG(" + oldErrorCode + ")))", "ERRORCODE(" + errorCode + ")"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$
						ServerAssignmentCommand basicUpdateCommand = new DmlMultipleAssignmentCommand(smartUpdateCommand).getServerAssignmentCommand();
						startTransaction.execDmlCommandAndEndTransaction(new ServerMultipleAssignmentCommand(new ServerAssignmentCommand[] { cascadeToAssignmentConstraintChecks, basicUpdateCommand }));
						// if successful, need to register success (set preUpdateState to be equal to the current (new) state) because we haven't used the jsba-level methods here.
						assignmentConstraint.setPreUpdateState();
					}
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			} catch (NoUpdatesException e) {

			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		if (!getPresentation().getName().equalsIgnoreCase(ASSIGNMENTCONSTRAINTSSELECT)) {
			// additional check might have been defined, refresh the screen
			processSelectedAssignmentConstraint();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return ASSIGNMENTCONSTRAINTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "AssignmentConstraintsManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}