package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.HashSet; //import java.util.logging.Logger;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.WAAR.PresentationLayer.*;

/**
 * Function to produce an overview of assignment constraints
 * 
 * @author Erwin
 */
public class AssignmentConstraintsOverview extends AssignmentConstraintsWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null || getPresentationValue("ERRORCODEFROM") != null || getPresentationValue("ERRORCODETO") != null) { //$NON-NLS-1$ //$NON-NLS-2$ 
			doPresentationLogic();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		String assignmentConstraintRelvar;

		WaarValue wv_relvarName = getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		if (wv_relvarName != null) {
			String relvarName = ((GenericStringValue) wv_relvarName).getString().trim();
			String restrictUsingConstraintChecksCondition = "EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (((LogicalValue) getPresentationValue("SELECTONLYOPERATIONTYPE")).getValue()) { //$NON-NLS-1$
				restrictUsingConstraintChecksCondition = "AND(" + restrictUsingConstraintChecksCondition + ",EQ(" + ATTRIBUTENAMES.OPERATIONTYPE + ",INT(" + ((NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE)).getIntegerValue() + ")))";   //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
			}
			assignmentConstraintRelvar = "SEMIJOIN(" + RELVARNAMES.ASSIGNMENTCONSTRAINT + ",PROJECT(RESTRICT(" + RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK + "," + restrictUsingConstraintChecksCondition + "),(" + ATTRIBUTENAMES.ERRORCODE + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
		} else {
			assignmentConstraintRelvar = RELVARNAMES.ASSIGNMENTCONSTRAINT;
		}

		GenericIntegerValue wv_errorCodeFrom = (GenericIntegerValue) getPresentationValue("ERRORCODEFROM"); //$NON-NLS-1$
		if (wv_errorCodeFrom != null) {
			assignmentConstraintRelvar = "RESTRICT(" + assignmentConstraintRelvar + ",GT(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + (Math.max(wv_errorCodeFrom.getInteger(), 0) - 1) + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
		}

		GenericIntegerValue wv_errorCodeTo = (GenericIntegerValue) getPresentationValue("ERRORCODETO"); //$NON-NLS-1$
		if (wv_errorCodeTo != null) {
			assignmentConstraintRelvar = "RESTRICT(" + assignmentConstraintRelvar + ",GT(LONG(" + wv_errorCodeTo.getInteger() + ")," + ATTRIBUTENAMES.ERRORCODE + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
		}

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			setPresentationValue("ASSIGNMENTCONSTRAINTLIST", getWAARListValue("ASSIGNMENTCONSTRAINTLIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction(assignmentConstraintRelvar), new HashSet<String>(Arrays.asList(new String[] { ATTRIBUTENAMES.SP_EXPRESSION, ATTRIBUTENAMES.CONSTRAINTLABEL })))); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "AssignmentConstraintsOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}