/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.WAAR.PresentationLayer.WAARApplicationException;

/**
 * @author Erwin
 * 
 */
abstract class AssignmentConstraintsWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String ASSIGNMENTCONSTRAINTSSELECT = "AssignmentConstraintsSelect"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @param errorCode
	 * @return
	 * @throws NoConnectionException
	 * @throws AssignmentConstraintNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	final AbstractRelation getAssignmentConstraint (SiraPriseServer sirapriseServer, long errorCode) throws NoConnectionException, AssignmentConstraintNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY); //$NON-NLS-1$
			String errorCodeCondition = "EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + errorCode + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			AbstractRelation tuples = startTransaction.execQueryAndEndTransaction("EXTEND(RESTRICT(LEFTJOIN(" + RELVARNAMES.ASSIGNMENTCONSTRAINT + "," + RELVARNAMES.CONSTRAINTMESSAGETEXT + "," + ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT + "(STRING()))," + errorCodeCondition + "),CHECKS(RESTRICT(" + RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK + "," + errorCodeCondition + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			if (tuples.size() < 1) {
				throw new AssignmentConstraintNotFoundException(errorCode, getUserLocale());
			}

			return tuples;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

}
