package be.SIRAPRISE.webclient;

import java.util.Collection;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.Attribute;
import be.SIRAPRISE.client.jsba.JavaBackedType;
import be.WAAR.PresentationLayer.*;

/**
 * Function to create an attribute.
 * 
 * @author Erwin
 */
public class AttributesCreate extends AttributesWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String attributeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME)).getString().trim();
		String typeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME)).getString().trim();
		GenericIntegerValue wv_logicalLength = ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.LOGICALLENGTH));
		int logicalLength = wv_logicalLength == null ? -1 : wv_logicalLength.getInteger();

		Attribute attribute = new Attribute(attributeName, typeName, logicalLength);
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$

			DmlAssignmentCommand[] cmds;

			Collection<JavaBackedType> typeInfoSet = getNewTypeInfoSet(typeName, startTransaction);
			if (typeInfoSet.size() > 0) {
				JavaBackedType newType = typeInfoSet.iterator().next();
				if (newType.getMinimumSize() == newType.getMaximumSize()) {
					if (logicalLength >= 0) {
						throw new LogicalLengthNotAllowedForFixedLengthTypesException(typeName, getUserLocale());
					}
					cmds = new DmlAssignmentCommand[] { attribute.dbAddCommand(RELVARNAMES.ATTRIBUTE) };
				} else {
					if (logicalLength < 0) {
						throw new LogicalLengthRequiredForVariableLengthTypesException(typeName, getUserLocale());
					}
					cmds = new DmlAssignmentCommand[] { attribute.dbAddCommand(RELVARNAMES.ATTRIBUTE), attribute.dbAddCommand(RELVARNAMES.ATTRIBUTELOGICALLENGTH) };
				}
			} else {
				// new attribute's type not found ; will fail but do it anyway so the error message pops up properly
				cmds = new DmlAssignmentCommand[] { attribute.dbAddCommand(RELVARNAMES.ATTRIBUTE) };
			}

			startTransaction.execMultipleStatementAndEndTransaction(cmds);

		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "AttributesCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}