package be.SIRAPRISE.webclient;

import java.util.Locale;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.Attribute;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.Relvar;
import be.WAAR.PresentationLayer.*;
import be.erwinsmout.MyMessageFormat;

/**
 * Function to delete an attribute definition
 * 
 * @author Erwin
 */
public class AttributesDelete extends AttributesWebClientFunction {

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedAttributeName ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		AttributeInfo attributeInfo = getAttributeInfo(sirapriseServer);
		Attribute attribute = attributeInfo.getAttribute();

		setPresentation("AttributesDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME, attribute.getName());
		setPresentationValue(ATTRIBUTENAMES.TYPENAME, attribute.getTypeName());

		if (attributeInfo.getRelation().size() > 0) {
			Locale userLocale = getUserLocale();
			try {
				setPresentationMessage(MyMessageFormat.format(I18N.getString(userLocale, "AttributesDelete.StillInRelvar"), new String[] { attributeInfo.getRelation().toObjectCollectionIgnoringMissingSetters(Relvar.class).iterator().next().getName() })); //$NON-NLS-1$
			} catch (ConstructorMissingException e) {
				throw new IllDefinedDBInterfaceClassException(e, userLocale);
			} catch (ClassDoesNotImplementDBObjectException e) {
				throw new IllDefinedDBInterfaceClassException(e, userLocale);
			}
		}
		
		saveInFunctionContext(RELVARNAMES.ATTRIBUTE, attributeInfo);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME) != null) {
			processSelectedAttributeName();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(ATTRIBUTESSELECT)) {
			// attributename entered, ask confirmation
			processSelectedAttributeName();
		} else {
			// confirmation entered, delete attribute
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

			Attribute attribute = ((AttributeInfo) getFromFunctionContextMandatory(RELVARNAMES.ATTRIBUTE)).getAttribute();
			setPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME, attribute.getName());
			setPresentationValue(ATTRIBUTENAMES.TYPENAME, attribute.getTypeName());

			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new DmlAssignmentCommand[] { attribute.dbDeleteCommand(RELVARNAMES.ATTRIBUTE), attribute.dbUnAssertCommand(RELVARNAMES.ATTRIBUTELOGICALLENGTH) }); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return ATTRIBUTESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "AttributesDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}