package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.LinkedList;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.Attribute;
import be.SIRAPRISE.client.jsba.JavaBackedType;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of an attribute
 * 
 * @author Erwin
 */
public class AttributesManage extends AttributesWebClientFunction {

	/**
	 * Reads the details of the selected attribute in the catalog and displays those on screen
	 * 
	 * @throws WaarException
	 */
	private void processSelectedAttributeName ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		AttributeInfo attributeInfo = getAttributeInfo(sirapriseServer);
		Attribute attribute = attributeInfo.getAttribute();

		setPresentation("AttributesManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME, attribute.getName());
		setPresentationValue(ATTRIBUTENAMES.TYPENAME, attribute.getTypeName());
		int logicalLength = attribute.getLogicalLength();
		if (logicalLength > -1) {
			setPresentationValue(ATTRIBUTENAMES.LOGICALLENGTH, logicalLength);
		}

		saveInFunctionContext(RELVARNAMES.ATTRIBUTE, attributeInfo);

		setRelvarList(attributeInfo.getRelation());
	}

	/**
	 * @param r
	 * @throws WaarException
	 */
	private void setRelvarList (AbstractRelation r) throws WaarException {
		setPresentationValue("RELVARLIST", getWAARListValue("RELVARLIST", r, null)); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME) != null) {
			processSelectedAttributeName();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(ATTRIBUTESSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedAttributeName();
		} else {
			// <OK> clicked on managedetails presentation ; try to modify attribute definition
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

			AttributeInfo attributeInfo = (AttributeInfo) getFromFunctionContextMandatory(RELVARNAMES.ATTRIBUTE);
			Attribute attribute = attributeInfo.getAttribute();
			Attribute preUpdateState = (Attribute) attribute.getPreUpdateState();

			String newAttributeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME)).getString().trim();
			String newTypeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME)).getString().trim();
			GenericIntegerValue wv_newLogicalLength = ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.LOGICALLENGTH));
			int newLogicalLength = wv_newLogicalLength == null ? -1 : wv_newLogicalLength.getInteger();

			String oldTypeName = preUpdateState.getTypeName();
			int oldLogicalLength = preUpdateState.getLogicalLength();

			attribute.setName(newAttributeName);
			attribute.setTypeName(newTypeName);

			DmlAssignmentCommand attributeCommand = null;
			LinkedList<DmlAssignmentCommand> commands = new LinkedList<DmlAssignmentCommand>();
			try {
				attributeCommand = attribute.dbUpdateCommand(RELVARNAMES.ATTRIBUTE);
				commands.addLast(attributeCommand);
			} catch (NoUpdatesException e) {

			}

			DmlAssignmentCommand logicalLengthCommand = null;
			try {
				if (!(oldLogicalLength == newLogicalLength)) {
					if (oldLogicalLength < 0) {
						// Insert new
						logicalLengthCommand = attribute.dbAddCommand(RELVARNAMES.ATTRIBUTELOGICALLENGTH);
					} else {
						if (newLogicalLength < 0) {
							// Delete
							logicalLengthCommand = attribute.dbDeleteCommand(RELVARNAMES.ATTRIBUTELOGICALLENGTH);
						} else {
							// Update
							logicalLengthCommand = attribute.dbUpdateCommand(RELVARNAMES.ATTRIBUTELOGICALLENGTH);
						}
					}
					commands.addLast(logicalLengthCommand);
				}
			} catch (NoUpdatesException e) {

			}

			if (commands.size() > 0) {
				DBConnection dbc = getDBConnection(sirapriseServer);
				try {
					DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
					// check for typechange ; extra checks to be done wrt new types log.length if typechange done
					if ((!oldTypeName.trim().equalsIgnoreCase(newTypeName.trim()))) {
						// Check whether new type fixed-length or variable-length
						Collection<JavaBackedType> typeInfoSet = getNewTypeInfoSet(newTypeName, startTransaction);
						if (typeInfoSet.size() > 0) {
							JavaBackedType newType = typeInfoSet.iterator().next();
							if (newType.getMinimumSize() == newType.getMaximumSize()) {
								// fixed-size
								if (newLogicalLength >= 0) {
									throw new LogicalLengthNotAllowedForFixedLengthTypesException(newTypeName, getUserLocale());
								}
							} else {
								// variable size
								if (newLogicalLength < 0) {
									throw new LogicalLengthRequiredForVariableLengthTypesException(newTypeName, getUserLocale());
								}
							}
						} else {
							// we just leave it at that even if we know that the update will fail on a missing type.
						}
					} else {
						// No type change ; logical lengths must both be -1 or both be positive
						if (oldLogicalLength >= 0 && newLogicalLength < 0) {
							// logicalLength "deleted", but not allowed
							throw new LogicalLengthRequiredForVariableLengthTypesException(newTypeName, getUserLocale());
						}
						if (newLogicalLength >= 0 && oldLogicalLength < 0) {
							// logicalLength "added" but not allowed
							throw new LogicalLengthNotAllowedForFixedLengthTypesException(newTypeName, getUserLocale());
						}
					}

					startTransaction.execMultipleStatementAndEndTransaction(commands);

					// save new values as ones in the function context
					saveInFunctionContext(RELVARNAMES.ATTRIBUTE, attribute);

					setRelvarList(attributeInfo.getRelation());
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return ATTRIBUTESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "AttributesManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}