package be.SIRAPRISE.webclient;

import java.util.Set;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * The function to produce an overview of defined attributes
 * 
 * @author Erwin
 */
public class AttributesOverview extends AttributesWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String restrictCondition = ""; //$NON-NLS-1$

		GenericIntegerValue wv_minimumLength = (GenericIntegerValue) getPresentationValue("MINLENGTH"); //$NON-NLS-1$
		if (wv_minimumLength != null) {
			restrictCondition = "GT(" + ATTRIBUTENAMES.LOGICALLENGTH + ",INT(" + (Math.max(wv_minimumLength.getInteger(), 0) - 1) + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
		}

		GenericIntegerValue wv_maximumLength = (GenericIntegerValue) getPresentationValue("MAXLENGTH"); //$NON-NLS-1$
		if (wv_maximumLength != null) {
			String maximumLengthCondition = "NOT(GT(" + ATTRIBUTENAMES.LOGICALLENGTH + ",INT(" + wv_maximumLength.getInteger() + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + maximumLengthCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			} else {
				restrictCondition = maximumLengthCondition;
			}
		}

		GenericStringValue namePattern = (GenericStringValue) getPresentationValue("NAMEPATTERN"); //$NON-NLS-1$
		if (namePattern != null) {
			String namePatternCondition = "MATCHES(THE_STRING(" + ATTRIBUTENAMES.ATTRIBUTENAME + "),STRING(" + namePattern.getString() + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + namePatternCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			} else {
				restrictCondition = namePatternCondition;
			}
		}

		//		String query = "UNION(JOIN(" + RELVARNAMES.ATTRIBUTE + "," + RELVARNAMES.ATTRIBUTELOGICALLENGTH + "),RENAME(PROJECT(RESTRICT(JOIN(" + RELVARNAMES.ATTRIBUTE + ",TCLOSE(PROJECT(" + RELVARNAMES.CONSTRAINEDTYPE + ",(" + ATTRIBUTENAMES.TYPENAME + "," + ATTRIBUTENAMES.BASETYPE + ")),(" + ATTRIBUTENAMES.TYPENAME + "," + ATTRIBUTENAMES.BASETYPE + ")),RENAME(" + RELVARNAMES.TYPEPROPERTIES + ",(" + ATTRIBUTENAMES.TYPENAME + "," + ATTRIBUTENAMES.BASETYPE + "))),EQ(" + ATTRIBUTENAMES.MINIMUMSIZE + "," + ATTRIBUTENAMES.MAXIMUMSIZE + ")),(" + ATTRIBUTENAMES.ATTRIBUTENAME + "," + ATTRIBUTENAMES.TYPENAME + "," + ATTRIBUTENAMES.MINIMUMSIZE + ")),(" + ATTRIBUTENAMES.MINIMUMSIZE + "," + ATTRIBUTENAMES.LOGICALLENGTH + ")),RENAME(PROJECT(RESTRICT(JOIN(" + RELVARNAMES.ATTRIBUTE + "," + RELVARNAMES.TYPEPROPERTIES + "),EQ(" + ATTRIBUTENAMES.MINIMUMSIZE + "," + ATTRIBUTENAMES.MAXIMUMSIZE + ")),(" + ATTRIBUTENAMES.ATTRIBUTENAME + "," + ATTRIBUTENAMES.TYPENAME + "," + ATTRIBUTENAMES.MINIMUMSIZE + ")),(" + ATTRIBUTENAMES.MINIMUMSIZE + "," + ATTRIBUTENAMES.LOGICALLENGTH + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$ //$NON-NLS-14$ //$NON-NLS-15$ //$NON-NLS-16$ //$NON-NLS-17$ //$NON-NLS-18$ //$NON-NLS-19$ //$NON-NLS-20$ //$NON-NLS-21$ //$NON-NLS-22$ //$NON-NLS-23$ //$NON-NLS-24$ //$NON-NLS-25$ //$NON-NLS-26$ //$NON-NLS-27$ //$NON-NLS-28$
		String query = "UNION(JOIN(" + RELVARNAMES.ATTRIBUTE + "," + RELVARNAMES.ATTRIBUTELOGICALLENGTH + "),RENAME(PROJECT(RESTRICT(UNGROUP(TRANSFORM(" + RELVARNAMES.ATTRIBUTE + ",(ATTRIBUTENAME,PROPS(__TYPEINFO(TYPENAME)))),(PROPS)),EQ(" + ATTRIBUTENAMES.MINIMUMSIZE + "," + ATTRIBUTENAMES.MAXIMUMSIZE + ")),(" + ATTRIBUTENAMES.ATTRIBUTENAME + "," + ATTRIBUTENAMES.TYPENAME + "," + ATTRIBUTENAMES.MINIMUMSIZE + ")),(" + ATTRIBUTENAMES.MINIMUMSIZE + "," + ATTRIBUTENAMES.LOGICALLENGTH + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
		if (restrictCondition.length() > 0) {
			query = "RESTRICT(" + query + "," + restrictCondition + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}

		WaarValue wv_typeNames = getPresentationValue(ATTRIBUTENAMES.TYPENAME);
		if (wv_typeNames != null) {
			Set<String> typeNames = RelationValueSelectorFactory.getNames(((GenericStringValue) wv_typeNames).getString());
			if (typeNames.size() > 0) {
				StringBuffer relationValue = new StringBuffer("RELATION(HEADING(" + ATTRIBUTENAMES.TYPENAME + "(NAME))BODY("); //$NON-NLS-1$ //$NON-NLS-2$
				for (String typeName : typeNames) {
					relationValue.append("TUPLE(").append(ATTRIBUTENAMES.TYPENAME).append("(").append(typeName).append("))"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
				}
				relationValue.append("))"); //$NON-NLS-1$
				query = "JOIN(" + query + "," + relationValue + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			}
		}

		// join in the appropriate types management function for the links in the overview
		query = "JOIN(" + query + ",UNION(TRANSFORM(" + RELVARNAMES.JAVABACKEDTYPE + ",(" + ATTRIBUTENAMES.TYPENAME + ",TYPESMANAGEFUNCTION(STRING(Types)))),TRANSFORM(" + RELVARNAMES.CONSTRAINEDTYPE + ",(" + ATTRIBUTENAMES.TYPENAME + ",TYPESMANAGEFUNCTION(STRING(ConstrainedTypes)))),TRANSFORM(" + RELVARNAMES.USERDEFINEDTYPE + ",(" + ATTRIBUTENAMES.TYPENAME + ",TYPESMANAGEFUNCTION(STRING(UserDefinedTypes))))))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			setPresentationValue("ATTRIBUTELIST", getWAARListValue("ATTRIBUTELIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.READONLY).execQueryAndEndTransaction(query), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "AttributesOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}