/**
 * 
 */
package be.SIRAPRISE.webclient;

import java.util.Collection;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.Attribute;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.JavaBackedType;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.WAARApplicationException;

/**
 * @author Erwin
 * 
 */
public abstract class AttributesWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String ATTRIBUTESSELECT = "AttributesSelect"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @return
	 * @throws NoConnectionException
	 * @throws AttributeNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	final AttributeInfo getAttributeInfo (SiraPriseServer sirapriseServer) throws NoConnectionException, AttributeNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		String attributeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME)).getString().trim();

		// Get the typename to save it in the sessioncontext
		DBConnection dbc = getDBConnection(sirapriseServer);
		Attribute attribute;
		AbstractRelation[] queryResults;
		try {
			queryResults = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueriesAndEndTransaction(new String[] { "RESTRICT(LEFTJOIN(" + RELVARNAMES.ATTRIBUTE + "," + RELVARNAMES.ATTRIBUTELOGICALLENGTH + "," + ATTRIBUTENAMES.LOGICALLENGTH + "(INT(-1))),EQ(" + ATTRIBUTENAMES.ATTRIBUTENAME + ",NAME(STRING(" + attributeName + "))))", "RESTRICT(" + RELVARNAMES.RELVARATTRIBUTE + ",EQ(" + ATTRIBUTENAMES.ATTRIBUTENAME + ",NAME(STRING(" + attributeName + "))))" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
			if (queryResults[0].size() < 1) {
				throw new AttributeNotFoundException(attributeName, getUserLocale());
			}
			attribute = queryResults[0].toObjectCollection(Attribute.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}

		return new AttributeInfo(attribute, queryResults[1]);
	}

	/**
	 * @param newTypeName
	 * @param startTransaction
	 * @return
	 * @throws ConnectionClosedException
	 * @throws ErrorMessageException
	 * @throws IllDefinedDBInterfaceClassException 
	 */
	final Collection<JavaBackedType> getNewTypeInfoSet (String newTypeName, DBTransaction startTransaction) throws ConnectionClosedException, ErrorMessageException, IllDefinedDBInterfaceClassException {
		try {
			return startTransaction.execQuery("__TYPEINFO(NAME(" + newTypeName + "))").toObjectCollectionIgnoringMissingSetters(JavaBackedType.class); //$NON-NLS-1$ //$NON-NLS-2$
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		}
	}

}
