package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.Client;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a client definition
 * 
 * @author Erwin
 */
public class ClientsDelete extends ClientsWebClientFunction {

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedClient ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		Client client = getClient(sirapriseServer);

		setPresentation("ClientsDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.CLIENTID, client.getID());
		setPresentationValue(ATTRIBUTENAMES.TRUSTAUTHENTICATION, client.isTrustAuthentications());

		saveInFunctionContext(RELVARNAMES.CLIENT, client);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.CLIENTID) != null) {
			processSelectedClient();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(CLIENTSSELECT)) {
			// attributename entered, ask confirmation
			processSelectedClient();
		} else {
			// confirmation entered, delete attribute
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

			Client client = (Client) getFromFunctionContextMandatory(RELVARNAMES.CLIENT);
			String clientID = client.getID();
			setPresentationValue(ATTRIBUTENAMES.CLIENTID, clientID);
			setPresentationValue(ATTRIBUTENAMES.TRUSTAUTHENTICATION, client.isTrustAuthentications());

			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new String[] { client.dbDeleteCommand(RELVARNAMES.CLIENT).getCommand(), ("UNASSERT " + RELVARNAMES.CLIENTCERTIFICATE + ",RESTRICT(" + RELVARNAMES.CLIENTCERTIFICATE + ",EQ(" + ATTRIBUTENAMES.CLIENTID + ",NAME(" + clientID + ")))") }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return CLIENTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "ClientsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}