package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.Client;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of a SIRA_PRISE client
 * 
 * @author Erwin
 */
public class ClientsManage extends ClientsWebClientFunction {

	/**
	 * Reads the details of the selected client in the catalog and displays those on screen
	 * 
	 * @throws WaarException
	 */
	private void processSelectedClient ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		Client client = getClient(sirapriseServer);

		setPresentation("ClientsManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		saveInFunctionContext(RELVARNAMES.CLIENT, client);
		setPresentationValue(ATTRIBUTENAMES.CLIENTID, client.getID());
		setPresentationValue(ATTRIBUTENAMES.TRUSTAUTHENTICATION, client.isTrustAuthentications());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.CLIENTID) != null) {
			processSelectedClient();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(CLIENTSSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedClient();
		} else {
			// <OK> clicked on managedetails presentation ; try to modify attribute definition
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

			Client client = (Client) getFromFunctionContextMandatory(RELVARNAMES.CLIENT);
			String newClientID = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CLIENTID)).getString().trim();
			client.setID(newClientID);
			client.setTrustAuthentications(((LogicalValue) getPresentationValue(ATTRIBUTENAMES.TRUSTAUTHENTICATION)).getValue());

			try {
				String cmd1 = client.dbUpdateCommand(RELVARNAMES.CLIENT).getCommand();

				DBConnection dbc = getDBConnection(sirapriseServer);
				try {
					if ((!newClientID.equalsIgnoreCase(((Client) client.getPreUpdateState()).getID()))) {
						String cmd2 = "CMD(UPDATE " + RELVARNAMES.CLIENTCERTIFICATE + ",RESTRICT(" + RELVARNAMES.CLIENTCERTIFICATE + ",EQ(" + ATTRIBUTENAMES.CLIENTID + ",NAME(" + newClientID + "))),(" + ATTRIBUTENAMES.CLIENTID + "(NAME(" + newClientID + "))" + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
						dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new String[] { cmd1, cmd2 }); //$NON-NLS-1$
					} else {
						dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execDmlCommandAndEndTransaction(cmd1); //$NON-NLS-1$
					}
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			} catch (NoUpdatesException e1) {
				//Nothing to do
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return CLIENTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "ClientsManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}