package be.SIRAPRISE.webclient;

import java.util.Set;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * The function to produce an overview of defined attributes
 * 
 * @author Erwin
 */
public class ClientsOverview extends ClientsWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			String query = "LEFTJOIN(" + NAMES.RELVARNAMES.CLIENT + ",GROUP(PROJECT(" + RELVARNAMES.CLIENTCERTIFICATE + ",(" + ATTRIBUTENAMES.CLIENTID + "," + ATTRIBUTENAMES.ALGORITHM + ")),ALGORITHMS(" + ATTRIBUTENAMES.ALGORITHM + ")),ALGORITHMS(RELATION(HEADING(" + ATTRIBUTENAMES.ALGORITHM + "(NAME))BODY())))";//$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-3$ //$NON-NLS-2$ //$NON-NLS-1$

			GenericStringValue wv_signingAlgorithms = (GenericStringValue) getPresentationValue("SIGNINGALGORITHMS"); //$NON-NLS-1$
			if (wv_signingAlgorithms != null) {
				Set<String> signingAlgorithms = RelationValueSelectorFactory.getNames(wv_signingAlgorithms.getString());
				StringBuffer signingAlgorithmsRelationText = new StringBuffer(30 * signingAlgorithms.size()).append("RELATION(HEADING(" + ATTRIBUTENAMES.ALGORITHM + "(NAME))BODY("); //$NON-NLS-1$ //$NON-NLS-2$
				for (String string : signingAlgorithms) {
					signingAlgorithmsRelationText.append("TUPLE(" + ATTRIBUTENAMES.ALGORITHM + "(NAME(" + string + ")))"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
				}
				signingAlgorithmsRelationText.append("))"); //$NON-NLS-1$
				query = "JOIN(" + query + ",JOIN(" + RELVARNAMES.CLIENTCERTIFICATE + "," + signingAlgorithmsRelationText + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
			}

			GenericStringValue wv_clientPattern = (GenericStringValue) getPresentationValue("CLIENTIDPATTERN"); //$NON-NLS-1$
			if (wv_clientPattern != null) {
				query = "RESTRICT(" + query + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.CLIENTID + "),STRING(" + wv_clientPattern.getString() + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
			}
			setPresentationValue("CLIENTLIST", getWAARListValue("CLIENTLIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction(query), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "ClientsOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}