package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.Relvar;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class CompareUpgradedToInstalledCatalog extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	private HashSet<String> contextRelvarNames = new HashSet<String>(Arrays.asList(RELVARNAMES.CURRENTCONTEXT, RELVARNAMES.CURRENTDATE, RELVARNAMES.CURRENTUPDATE, RELVARNAMES.CURRENTUSER));

	/**
	 * 
	 */
	private static final HashMap<String, String> doProjectionFor = new HashMap<String, String>();

	static {
		doProjectionFor.put(RELVARNAMES.STORAGESPACE, ATTRIBUTENAMES.FILENAME + "," + ATTRIBUTENAMES.STORAGESPACEID); //$NON-NLS-1$
		doProjectionFor.put(RELVARNAMES.USERCERTIFICATE, ATTRIBUTENAMES.ALGORITHM + "," + ATTRIBUTENAMES.USERID); //$NON-NLS-1$
		doProjectionFor.put(RELVARNAMES.CLIENTCERTIFICATE, ATTRIBUTENAMES.ALGORITHM + "," + ATTRIBUTENAMES.CLIENTID); //$NON-NLS-1$
		doProjectionFor.put(RELVARNAMES.RELVARCARDINALITY, ATTRIBUTENAMES.RELVARNAME);
//		doProjectionFor.put(RELVARNAMES.STORAGESPACEEXTENTS, ATTRIBUTENAMES.FILENAME + "," + ATTRIBUTENAMES.STORAGESPACEID); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		ListValue relvarList = new ListValue("RELVARLIST"); //$NON-NLS-1$

		DBConnection connectionToUpgradedServer = getDBConnection(((GenericStringValue) getPresentationValue("UPGRADEDSERVER")).getString().trim(), ((GenericIntegerValue) getPresentationValue("UPGRADEDPORT")).getInteger(), getUserLocale()); //$NON-NLS-1$ //$NON-NLS-2$
		DBConnection connectionToSysgennedServer = getDBConnection(((GenericStringValue) getPresentationValue("SYSGENNEDSERVER")).getString().trim(), ((GenericIntegerValue) getPresentationValue("SYSGENNEDPORT")).getInteger(), getUserLocale()); //$NON-NLS-1$ //$NON-NLS-2$

		try {
			DBTransaction upgradedEngineTransaction = connectionToUpgradedServer.startTransaction();
			DBTransaction sysGennedEngineTransaction = connectionToSysgennedServer.startTransaction();

			Collection<Relvar> relvars = sysGennedEngineTransaction.execQuery("PROJECT(JOIN(" + RELVARNAMES.SYSTEMDEFINEDRELVAR + "," + RELVARNAMES.RELVAR + ")," + ATTRIBUTENAMES.RELVARNAME + ")").toObjectCollectionIgnoringMissingSetters(Relvar.class); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			for (Relvar relvar : relvars) {
				String relvarName = relvar.getName();
				if (!(contextRelvarNames.contains(relvarName))) {
					String rtx_upgraded = upgradedEngineTransaction.execQuery(getQuery(relvarName)).printValueEscapedWithTypeNames();
					String rtx_sysgenned = sysGennedEngineTransaction.execQuery(getQuery(relvarName)).printValueEscapedWithTypeNames();
					AbstractRelation symmetricDifference = sysGennedEngineTransaction.execQuery("XMINUS(" + rtx_upgraded + "," + rtx_sysgenned + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					if (symmetricDifference.size() > 0) {
						relvarList.append(rowHashMapFor(relvarName));
					}
				}
			}

			setPresentationValue("RELVARLIST", relvarList); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			connectionToSysgennedServer.close();
			connectionToUpgradedServer.close();
		}
	}

	/**
	 * @param relvarName
	 * @return
	 */
	private String getQuery (String relvarName) {
		if (doProjectionFor.containsKey(relvarName)) {
			return "PROJECT(" + relvarName + ",(" + doProjectionFor.get(relvarName) + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
		} else {
			return relvarName;
		}
	}

	/**
	 * @param name
	 * @return
	 */
	private HashMap<String, WaarValue> rowHashMapFor (String name) {
		HashMap<String, WaarValue> hashMap = new HashMap<String, WaarValue>();
		hashMap.put(ATTRIBUTENAMES.RELVARNAME, new GenericStringValue(name));
		return hashMap;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "CompareUpgradedToInstalledCatalog.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}